/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.xpl;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.vpe.editor.xpl.CustomSashForm;
import org.jboss.tools.vpe.editor.xpl.EditorSettings;

public class SashSetting
implements EditorSettings.ISetting {
    public static final String id = "Settings.Sash";
    private IEditorPart editor;
    private IResource resource;
    private QualifiedName name;
    private CustomSashForm sash;
    private Control listenedControl = null;
    private int[] weights;

    public SashSetting(CustomSashForm s) {
        this.sash = s;
    }

    @Override
    public void apply() {
        int defaultWeight = JspEditorPlugin.getDefault().getPreferenceStore().getInt("Size of Visual Editor Pane 0-100%");
        int[] weights = this.sash.getWeights();
        if (weights.length > 2) {
            String splitting = JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
            if (defaultWeight == 0) {
                if (CustomSashForm.isSourceEditorFirst(splitting)) {
                    this.sash.maxDown();
                } else {
                    this.sash.maxUp();
                }
            } else if (defaultWeight == 1000) {
                if (CustomSashForm.isSourceEditorFirst(splitting)) {
                    this.sash.maxUp();
                } else {
                    this.sash.maxDown();
                }
            } else {
                if (CustomSashForm.isSourceEditorFirst(splitting)) {
                    weights[0] = 1000 - defaultWeight;
                    weights[1] = defaultWeight;
                } else {
                    weights[0] = defaultWeight;
                    weights[1] = 1000 - defaultWeight;
                }
                this.sash.setWeights(weights);
            }
        }
    }

    @Override
    public void setQualifier(String q) {
        this.name = new QualifiedName(q, id);
    }

    @Override
    public void setEditor(IEditorPart e) {
        this.editor = e;
    }

    @Override
    public void setResource(IResource r) {
        this.resource = r;
    }

    @Override
    public void dispose() {
    }
}

