/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.web.WebUtils;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceList;

public class FileUtil {
    private static final String JSF2_RESOURCES = "/resources/";

    public static final String getJSF2ResourcePath(VpePageContext pageContext, String resourceStr) {
        if (resourceStr.contains(":")) {
            String[] parts = resourceStr.split(":");
            return FileUtil.getJSF2ResourcePath(pageContext, parts[0], parts[1]);
        }
        return FileUtil.getJSF2ResourcePath(pageContext, null, resourceStr);
    }

    public static final String getJSF2ResourcePath(VpePageContext pageContext, String library, String name) {
        String tempPath = library == null ? name : String.valueOf(library) + '/' + name;
        tempPath = JSF2_RESOURCES + tempPath;
        String result = "";
        IFile file = VpeCreatorUtil.getFile(tempPath, pageContext);
        if (file == null) {
            String tempEntryPath = FileUtil.seachResourceInClassPath(pageContext, "META-INF" + tempPath);
            if (tempEntryPath != null) {
                result = tempEntryPath;
            }
        } else {
            result = file.getLocation().toString();
        }
        return result;
    }

    public static boolean isExistsInJSF2Resources(VpePageContext pageContext, String resStr) {
        String resourceString = resStr;
        resourceString = resourceString.replaceAll(":", "/");
        resourceString = JSF2_RESOURCES + resourceString;
        return FileUtil.getFile(pageContext.getEditPart().getEditorInput(), resourceString) != null || FileUtil.seachResourceInClassPath(pageContext, "META-INF" + resourceString) != null;
    }

    private static IJavaProject getJavaProject(VpePageContext pageContext) {
        VpeVisualDomBuilder visualBuilder = pageContext != null ? pageContext.getVisualBuilder() : null;
        VpeIncludeInfo currentIncludeInfo = visualBuilder != null ? visualBuilder.getCurrentIncludeInfo() : null;
        IFile currentFile = currentIncludeInfo != null ? (IFile)currentIncludeInfo.getStorage() : null;
        IProject project = currentFile != null ? currentFile.getProject() : null;
        return JavaCore.create((IProject)project);
    }

    private static String seachResourceInClassPath(VpePageContext pageContext, String classPathResource) {
        IJavaProject javaProject = FileUtil.getJavaProject(pageContext);
        if (javaProject == null) {
            return null;
        }
        String result = null;
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f;
                IResource resource;
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot instanceof JarPackageFragmentRoot) {
                    JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)fragmentRoot;
                    ZipEntry zipEntry = jarPackageFragmentRoot.getJar().getEntry(classPathResource);
                    if (zipEntry != null) {
                        InputStream inputStream = jarPackageFragmentRoot.getJar().getInputStream(zipEntry);
                        IPath stateLocation = VpePlugin.getDefault().getStateLocation();
                        String fileName = null;
                        String fileExtension = null;
                        if (classPathResource.lastIndexOf(".") != -1) {
                            fileName = classPathResource.substring(classPathResource.lastIndexOf("/") + 1, classPathResource.lastIndexOf("."));
                            fileExtension = classPathResource.substring(classPathResource.lastIndexOf("."), classPathResource.length());
                        }
                        if (fileName != null && fileName.length() > 0 && fileExtension != null && fileExtension.length() > 0) {
                            int len;
                            File temporaryFile = File.createTempFile(fileName, fileExtension, new File(stateLocation.toOSString()));
                            temporaryFile.deleteOnExit();
                            FileOutputStream out = new FileOutputStream(temporaryFile, false);
                            byte[] buf = new byte[1024];
                            while ((len = inputStream.read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            inputStream.close();
                            ((OutputStream)out).close();
                            result = temporaryFile.getAbsolutePath();
                        }
                    }
                } else if (fragmentRoot instanceof JavaElement && (resource = ((JavaElement)fragmentRoot).resource()) instanceof IContainer && resource.exists() && (f = ((IContainer)resource).getFile((IPath)new Path(classPathResource))).exists()) {
                    result = f.getLocation().toFile().getAbsolutePath();
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            VpePlugin.reportProblem(e);
        }
        catch (FileNotFoundException e) {
            VpePlugin.reportProblem(e);
        }
        catch (CoreException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        catch (IOException e) {
            VpePlugin.reportProblem(e);
        }
        return result;
    }

    public static IFile getFile(IEditorInput input, String fileName) {
        Path tagPath = new Path(fileName);
        if (tagPath.isEmpty()) {
            return null;
        }
        if (input instanceof IFileEditorInput) {
            return FileUtil.getFile(fileName, ((IFileEditorInput)input).getFile());
        }
        if (input instanceof ILocationProvider) {
            IPath path = ((ILocationProvider)input).getPath((Object)input);
            if (path == null || path.segmentCount() < 1) {
                return null;
            }
            path = path.removeLastSegments(1).append(fileName);
            return EclipseResourceUtil.getFile((String)path.toString());
        }
        return null;
    }

    public static IFile getFile(String fileName, IFile includeFile) {
        IFile file = null;
        if (fileName.startsWith("/")) {
            ResourceReference[] resources = AbsoluteFolderReferenceList.getInstance().getAllResources(includeFile);
            if (resources.length == 1) {
                String location = String.valueOf(resources[0].getLocation()) + fileName;
                Path path = new Path(location);
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            } else {
                IContainer[] webRootFolders = WebUtils.getWebRootFolders((IProject)includeFile.getProject());
                if (webRootFolders.length > 0) {
                    IContainer[] iContainerArray = webRootFolders;
                    int n = webRootFolders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer webRootFolder = iContainerArray[n2];
                        IFile handle = webRootFolder.getFile((IPath)new Path(fileName));
                        if (handle.exists()) {
                            file = handle;
                            break;
                        }
                        ++n2;
                    }
                } else {
                    file = FileUtil.resolveRelatedPath(includeFile, fileName);
                }
            }
        } else {
            ResourceReference[] resources = RelativeFolderReferenceList.getInstance().getAllResources(includeFile);
            if (resources.length == 1) {
                String location = String.valueOf(resources[0].getLocation()) + File.separator + fileName;
                Path path = new Path(location);
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            } else {
                file = FileUtil.resolveRelatedPath(includeFile, fileName);
            }
        }
        return file;
    }

    public static IFolder getDefaultWebRootFolder(IFile file) {
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        IContainer[] webRootFolders = WebUtils.getWebRootFolders((IProject)project);
        IPath defaultWebRootPath = null;
        if (webRootFolders.length > 0) {
            defaultWebRootPath = webRootFolders[0].getFullPath();
        }
        if (defaultWebRootPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(defaultWebRootPath);
    }

    private static IFile resolveRelatedPath(IFile baseFile, String relatedFilePath) {
        IPath currentFolder = baseFile.getParent().getFullPath();
        IPath path = currentFolder.append(relatedFilePath);
        IFile handle = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return handle.exists() ? handle : null;
    }

    public static void openEditor(IFile file) {
        IWorkbenchPage workbenchPage = VpePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            if (file != null) {
                IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException ex) {
            VpePlugin.reportProblem((Exception)((Object)ex));
        }
    }

    public static IPath getInputPath(IEditorInput input) {
        IFile inputFile;
        IPath inputPath = null;
        if (input instanceof ILocationProvider) {
            inputPath = ((ILocationProvider)input).getPath((Object)input);
        } else if (input instanceof IFileEditorInput && (inputFile = ((IFileEditorInput)input).getFile()) != null) {
            inputPath = inputFile.getLocation();
        }
        return inputPath;
    }
}

