/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.textformating;

import org.jboss.tools.vpe.editor.template.textformating.FormatAttributeData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FormatData {
    private FormatAttributeData[] formatAttributes;
    private String type;
    private String addChildren;
    private String addParent;
    private boolean addChildrenIsAllowIfParentDoesntDeny = false;
    private boolean addChildrenIsAllow = false;
    private boolean addChildrenIsDeny = false;
    private boolean addChildrenByItself = false;
    private String addChildrenHandler;
    private boolean addParentIsAllowIfParentDoesntDeny = false;
    private boolean addParentIsAllow = false;
    private boolean addParentIsDeny = false;
    private boolean addParentByItself = false;
    private String handler;
    private boolean setDefault = false;

    public FormatData(Element formatElement) {
        NodeList list = formatElement.getElementsByTagName("vpe:formatAttribute");
        this.formatAttributes = new FormatAttributeData[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            this.formatAttributes[i] = new FormatAttributeData(this, element);
            ++i;
        }
        this.type = formatElement.getAttribute("type");
        this.addChildren = formatElement.getAttribute("addChildren");
        this.addChildrenHandler = formatElement.getAttribute("addChildrenHandler");
        this.handler = formatElement.getAttribute("handler");
        this.setDefault = "true".equals(formatElement.getAttribute("setDefault"));
        this.setAddChildrenFlags();
        this.addParent = formatElement.getAttribute("addParent");
        this.setAddParentFlags();
    }

    private FormatData() {
    }

    private void setAddChildrenFlags() {
        if ("allow".equals(this.addChildren)) {
            this.addChildrenIsAllow = true;
        } else if ("deny".equals(this.addChildren)) {
            this.addChildrenIsDeny = true;
        } else if ("itself".equals(this.addChildren)) {
            this.addChildrenByItself = true;
        } else {
            this.addChildrenIsAllowIfParentDoesntDeny = true;
        }
    }

    private void setAddParentFlags() {
        if ("allow".equals(this.addParent)) {
            this.addParentIsAllow = true;
        } else if ("deny".equals(this.addParent)) {
            this.addParentIsDeny = true;
        } else if ("allow".equals(this.addParent)) {
            this.addParentByItself = true;
        } else {
            this.addParentIsAllowIfParentDoesntDeny = true;
        }
    }

    public boolean isAddingChildrenByItself() {
        return this.addChildrenByItself;
    }

    public boolean isAddingChildrenAllowIfParentDoesntDeny() {
        return this.addChildrenIsAllowIfParentDoesntDeny;
    }

    public boolean isAddingChildrenAllow() {
        return this.addChildrenIsAllow;
    }

    public boolean isAddingChildrenDeny() {
        return this.addChildrenIsDeny;
    }

    public FormatAttributeData[] getFormatAttributes() {
        return this.formatAttributes;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSetDefault() {
        return this.setDefault;
    }

    public String getAddChildrenHandler() {
        return this.addChildrenHandler;
    }

    public boolean isAddingParentAllow() {
        return this.addParentIsAllow;
    }

    public boolean isAddingParentAllowIfParentDoesntDeny() {
        return this.addParentIsAllowIfParentDoesntDeny;
    }

    public boolean isAddingParentDeny() {
        return this.addParentIsDeny;
    }

    public boolean isAddingParentByItself() {
        return this.addParentByItself;
    }
}

