/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.List;
import java.util.Map;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeStyleCreator
extends VpeAbstractCreator {
    public VpeStyleCreator(Element element, VpeDependencyMap dependencyMap, boolean caseSensitive) {
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) {
        Node textNode = sourceNode.getFirstChild();
        String text = null;
        if (textNode != null) {
            text = textNode.getNodeValue();
            text = VpeStyleUtil.removeAllCssComments(text);
            List<String> imports = VpeStyleUtil.findCssImportConstruction(text, pageContext);
            VpeVisualDomBuilder vvdb = pageContext.getVisualBuilder();
            if (imports.size() > 0) {
                for (String key : imports) {
                    vvdb.addLinkNodeToHead(key, "css_import_construction", false);
                }
                text = VpeStyleUtil.removeAllCssImportConstructions(text);
            }
            text = VpeStyleUtil.addFullPathIntoURLValue(text, pageContext);
        }
        nsIDOMNode newStyle = pageContext.getVisualBuilder().addStyleNodeToHead(text);
        visualNodeMap.put(this, newStyle);
        return null;
    }

    @Override
    public void removeElement(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        nsIDOMNode styleNode = (nsIDOMNode)visualNodeMap.get(this);
        if (styleNode != null) {
            pageContext.getVisualBuilder().removeStyleNodeFromHead(styleNode);
            visualNodeMap.remove(this);
        }
    }

    @Override
    public void refreshElement(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        nsIDOMNode oldStyleNode = (nsIDOMNode)visualNodeMap.get(this);
        Node textNode = sourceElement.getFirstChild();
        String text = null;
        if (textNode != null) {
            text = textNode.getNodeValue();
        }
        if (oldStyleNode == null) {
            nsIDOMNode newStyleNode = pageContext.getVisualBuilder().addStyleNodeToHead(text);
            visualNodeMap.put(this, newStyleNode);
        } else {
            nsIDOMNode newStyleNode = pageContext.getVisualBuilder().replaceStyleNodeToHead(oldStyleNode, text);
            if (visualNodeMap.containsKey(this)) {
                visualNodeMap.remove(this);
            }
            visualNodeMap.put(this, newStyleNode);
        }
    }
}

