/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeListCreator
extends VpeAbstractCreator {
    private boolean caseSensitive;
    private List propertyCreators;
    private Set dependencySet;
    private VpeExpression layoutExpr;

    VpeListCreator(Element listElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(listElement, dependencyMap);
    }

    private void build(Element listElement, VpeDependencyMap dependencyMap) {
        Attr layoutAttr = listElement.getAttributeNode("ordered");
        if (layoutAttr != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(layoutAttr.getValue(), this.caseSensitive);
                this.layoutExpr = info.getExpression();
                this.dependencySet = info.getDependencySet();
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if (VpeTemplateManager.ATTR_LIST_PROPERTIES != null) {
            int i = 0;
            while (i < VpeTemplateManager.ATTR_LIST_PROPERTIES.length) {
                String attrName = VpeTemplateManager.ATTR_LIST_PROPERTIES[i];
                Attr attr = listElement.getAttributeNode(attrName);
                if (attr != null) {
                    if (this.propertyCreators == null) {
                        this.propertyCreators = new ArrayList();
                    }
                    this.propertyCreators.add(new VpeAttributeCreator(attrName, attr.getValue(), dependencyMap, this.caseSensitive));
                }
                ++i;
            }
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        int count;
        VpeValue vpeValue;
        String strValue = null;
        int listSize = 0;
        if (this.layoutExpr != null && (vpeValue = this.layoutExpr.exec(pageContext, sourceNode)) != null) {
            strValue = vpeValue.stringValue();
        }
        nsIDOMElement visualList = visualDocument.createElement("true".equals(strValue) ? "ol" : "ul");
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo((nsIDOMNode)visualList);
        int i = 0;
        while (i < this.propertyCreators.size()) {
            VpeCreatorInfo info;
            VpeCreator creator = (VpeCreator)this.propertyCreators.get(i);
            if (creator != null && (info = creator.create(pageContext, (Element)sourceNode, visualDocument, visualList, visualNodeMap)) != null && info.getVisualNode() != null) {
                nsIDOMAttr attr = (nsIDOMAttr)info.getVisualNode();
                visualList.setAttributeNode(attr);
            }
            ++i;
        }
        NodeList children = sourceNode.getChildNodes();
        int n = count = children != null ? children.getLength() : 0;
        if (count > 0) {
            Node[] sourceChildren = new Node[count];
            int childrenCount = 0;
            int i2 = 0;
            while (i2 < count) {
                Node node = children.item(i2);
                short type = node.getNodeType();
                if (type == 1 || type == 3 && node.getNodeValue().trim().length() > 0) {
                    sourceChildren[childrenCount] = node;
                    ++childrenCount;
                }
                ++i2;
            }
            if (childrenCount > 0) {
                if (listSize == 0) {
                    listSize = childrenCount;
                }
                i2 = 0;
                while (i2 < listSize) {
                    nsIDOMElement visualLi = visualDocument.createElement("li");
                    VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualLi);
                    childrenInfo.addSourceChild(sourceChildren[i2]);
                    creatorInfo.addChildrenInfo(childrenInfo);
                    visualList.appendChild((nsIDOMNode)visualLi);
                    ++i2;
                }
            }
        }
        creatorInfo.addDependencySet(this.dependencySet);
        return creatorInfo;
    }
}

