/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.util.HashSet;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.proxy.VpeProxyUtil;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpePreviewDomBuilder
extends VpeVisualDomBuilder {
    public VpePreviewDomBuilder(VpeDomMapping domMapping, INodeAdapter sorceAdapter, VpeTemplateManager templateManager, MozillaEditor visualEditor, VpePageContext pageContext) {
        super(domMapping, sorceAdapter, visualEditor, pageContext);
    }

    @Override
    public nsIDOMNode createNode(Node sourceNode, nsIDOMNode visualOldContainer, boolean onlyOneIncludeStack) {
        VpeCreationData creationData;
        HashSet ifDependencySet = new HashSet();
        if (sourceNode == null || sourceNode.getNodeType() != 3 && sourceNode.getNodeType() != 1 && sourceNode.getNodeType() != 8 && sourceNode.getNodeType() != 9) {
            return null;
        }
        this.getPageContext().setCurrentVisualNode(visualOldContainer);
        VpeTemplate template = this.getTemplateManager().getTemplate(this.getPageContext(), sourceNode, ifDependencySet);
        try {
            if (this.getPageContext().getElService().isELNode(sourceNode)) {
                Node sourceNodeProxy = VpeProxyUtil.createProxyForELExpressionNode(this.getPageContext(), sourceNode);
                try {
                    creationData = template.create(this.getPageContext(), sourceNodeProxy, this.getVisualDocument());
                }
                catch (ClassCastException ex) {
                    VpePlugin.reportProblem(ex);
                    creationData = template.create(this.getPageContext(), sourceNode, this.getVisualDocument());
                }
            } else {
                creationData = template.create(this.getPageContext(), sourceNode, this.getVisualDocument());
            }
        }
        catch (XPCOMException ex) {
            VpePlugin.getPluginLog().logError((Throwable)ex);
            VpeTemplate defTemplate = this.getTemplateManager().getDefTemplate();
            creationData = defTemplate.create(this.getPageContext(), sourceNode, this.getVisualDocument());
        }
        this.getPageContext().setCurrentVisualNode(null);
        nsIDOMNode visualNewNode = creationData.getNode();
        if (sourceNode instanceof Element && visualNewNode != null) {
            this.setTooltip((Element)sourceNode, (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNewNode, nsIDOMElement.class));
            this.correctVisualAttribute((nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNewNode, nsIDOMElement.class));
        }
        if (template.hasChildren()) {
            List<VpeChildrenInfo> childrenInfoList = creationData.getChildrenInfoList();
            if (childrenInfoList == null) {
                this.addChildren(template, sourceNode, visualNewNode != null ? visualNewNode : visualOldContainer);
            } else {
                this.addChildren(template, sourceNode, visualOldContainer, childrenInfoList);
            }
        }
        this.getPageContext().setCurrentVisualNode(visualOldContainer);
        template.validate(this.getPageContext(), sourceNode, this.getVisualDocument(), creationData);
        this.getPageContext().setCurrentVisualNode(null);
        return visualNewNode;
    }
}

