/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.engines.impl.EnginesLoader;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.NamespaceMapping;
import org.jboss.tools.common.model.util.Paths;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XModelObjectLoaderUtil {
    public static String ENT_ANY_ELEMENT = "AnyElement";
    public static String ATTR_ID_NAME = "_id_";
    private Hashtable<String, String> singular = null;
    private boolean saveentity = true;
    private String namespace = null;
    private NamespaceMapping namespaceMapping = null;
    protected String error = null;
    static Map<XModelEntity, Set<String>> allowedChildren = new HashMap<XModelEntity, Set<String>>();

    public void setup(Hashtable<String, String> singular, boolean saveentity) {
        this.singular = singular;
        this.saveentity = saveentity;
        this.error = null;
    }

    public String getError() {
        return this.error;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setNamespaceMapping(NamespaceMapping nm) {
        this.namespaceMapping = nm;
    }

    public void setSaveEntity(boolean b) {
        this.saveentity = b;
    }

    public void load(Element element, XModelObject o) {
        if (ENT_ANY_ELEMENT.equals(o.getModelEntity().getName())) {
            this.loadAnyElement(element, o);
        } else {
            Set<String> allowed;
            this.loadAttributes(element, o);
            this.loadChildren(element, o);
            if (this.error != null || (allowed = this.getAllowedChildren(o.getModelEntity())) == null || this.hasUnallowedChildren(element, allowed)) {
                // empty if block
            }
            if (this.error != null || (allowed = this.getAllowedAttributes(o.getModelEntity())) == null || this.hasUnallowedAttributes(element, allowed)) {
                // empty if block
            }
        }
    }

    protected Set<String> getAllowedChildren(XModelEntity entity) {
        if (entity.getChild(ENT_ANY_ELEMENT) != null) {
            return null;
        }
        Set<String> x = allowedChildren.get(entity);
        if (x != null) {
            return x;
        }
        HashSet<String> children = new HashSet<String>();
        XAttribute[] as = entity.getAttributes();
        int i = 0;
        while (i < as.length) {
            String xml = as[i].getXMLName();
            if (xml != null) {
                int s = xml.indexOf(124);
                if (s > 0) {
                    StringTokenizer st = new StringTokenizer(xml, "|");
                    while (st.hasMoreTokens()) {
                        String dxml = st.nextToken();
                        int k = dxml.indexOf(46);
                        if (k < 0) continue;
                        children.add(dxml.substring(0, k));
                    }
                } else {
                    int k = xml.indexOf(46);
                    if (k >= 0) {
                        children.add(xml.substring(0, k));
                    }
                }
            }
            ++i;
        }
        XChild[] cs = entity.getChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            XModelEntity c = entity.getMetaModel().getEntity(cs[i2].getName());
            if (c != null) {
                int k;
                String xml = c.getXMLSubPath();
                if ((xml == null || xml.length() == 0) && cs[i2].isRequired()) {
                    Set<String> a1 = this.getAllowedChildren(c);
                    if (a1 == null) {
                        return null;
                    }
                    children.addAll(a1);
                }
                if ((k = xml.indexOf(46)) >= 0) {
                    xml = xml.substring(0, k);
                }
                children.add(xml);
            }
            ++i2;
        }
        if (children != null) {
            allowedChildren.put(entity, children);
        }
        return children;
    }

    protected Set<String> getAllowedAttributes(XModelEntity entity) {
        if (entity.getChild(ENT_ANY_ELEMENT) != null) {
            return null;
        }
        HashSet<String> attributes = new HashSet<String>();
        if (this.saveentity) {
            attributes.add(XModelConstants.XMODEL_ENTITY_ATTR);
            attributes.add(XModelConstants.XMODEL_ENTITY_ATTR_OLD);
        }
        XAttribute[] as = entity.getAttributes();
        int i = 0;
        while (i < as.length) {
            String xml = as[i].getXMLName();
            if (xml != null) {
                int s = xml.indexOf(124);
                if (s > 0) {
                    StringTokenizer st = new StringTokenizer(xml, "|");
                    while (st.hasMoreTokens()) {
                        String dxml = st.nextToken();
                        int k = dxml.indexOf(46);
                        if (k >= 0) continue;
                        attributes.add(dxml);
                    }
                } else {
                    int k = xml.indexOf(46);
                    if (k < 0) {
                        attributes.add(xml);
                    }
                }
            }
            ++i;
        }
        return attributes;
    }

    private boolean hasUnallowedChildren(Element element, Set<String> allowed) {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                String name = n.getNodeName();
                if (this.namespaceMapping != null) {
                    name = this.namespaceMapping.convertToDefault(name);
                }
                if (!allowed.contains(name)) {
                    this.error = MessageFormat.format("Editor model does not support child element {0} of {1}:0:0", name, element.getNodeName());
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean hasUnallowedAttributes(Element element, Set<String> allowed) {
        NamedNodeMap nl = element.getAttributes();
        int i = 0;
        while (i < nl.getLength()) {
            String name;
            Node n = nl.item(i);
            if (n.getNodeType() == 2 && !allowed.contains(name = n.getNodeName()) && !name.startsWith("xmlns")) {
                this.error = MessageFormat.format("Editor model does not support attribute {0} of {1}:0:0", name, element.getNodeName());
                return true;
            }
            ++i;
        }
        return false;
    }

    public void loadAttributes(Element element, XModelObject o) {
        XModelEntity entity = o.getModelEntity();
        XAttribute[] as = entity.getAttributes();
        int i = 0;
        while (i < as.length) {
            String n = as[i].getName();
            if ("attributes".equals(n) && "true".equals(as[i].getProperty("any"))) {
                XModelObjectLoaderUtil.loadAnyAtributes(element, o);
            } else {
                String xmlname = as[i].getXMLName();
                if (xmlname != null && xmlname.length() != 0) {
                    String comment;
                    String fn;
                    Element child;
                    String commentName;
                    String value = this.getAttribute(element, xmlname, as[i]);
                    if (value != null) {
                        o.setAttributeValue(n, value);
                    }
                    if ((commentName = XModelObjectLoaderUtil.getAttributeCommentName(xmlname)) != null && (child = XMLUtilities.getFirstChild((Element)element, (String)(fn = xmlname.substring(0, xmlname.indexOf(46))))) != null && (comment = XModelObjectLoaderUtil.getComment(child)) != null && comment.length() > 0) {
                        o.set(commentName, comment);
                    }
                }
            }
            ++i;
        }
        String s = XModelObjectLoaderUtil.getFinalComment(element);
        if (s != null && s.length() > 0) {
            o.set("#final-comment", s);
        }
    }

    private String applyNamespaceToAttribute(String xmlname) {
        if (this.namespaceMapping != null) {
            xmlname = this.namespaceMapping.convertToActual(xmlname);
        }
        if (this.namespace == null || this.namespace.length() == 0) {
            return xmlname;
        }
        if (xmlname.indexOf(58) > 0 || xmlname.indexOf(46) >= 0 || xmlname.indexOf(35) >= 0) {
            return xmlname;
        }
        if (xmlname.equals("xmlns")) {
            return String.valueOf(xmlname) + ":" + this.namespace;
        }
        return xmlname;
    }

    public final String applyNamespaceToTag(String xmlname) {
        if (this.namespaceMapping != null) {
            xmlname = this.namespaceMapping.convertToActual(xmlname);
        }
        if (this.namespace != null && this.namespace.length() > 0) {
            return String.valueOf(this.namespace) + ":" + xmlname;
        }
        return xmlname;
    }

    public String getAttribute(Element element, String xmlname) {
        return this.getAttribute(element, xmlname, null);
    }

    public String getAttribute(Element element, String xmlname, XAttribute attr) {
        if (xmlname.equals("CDATA") || xmlname.equals("#text")) {
            return XModelObjectLoaderUtil.getCDATA(element, attr == null || attr.isTrimmable());
        }
        if (xmlname.equals("#comment")) {
            return XModelObjectLoaderUtil.getComment(element);
        }
        int ind = xmlname.indexOf(46);
        if (ind > 0) {
            Element child;
            String childName = xmlname.substring(0, ind);
            if (this.namespaceMapping != null) {
                childName = this.namespaceMapping.convertToActual(childName);
            }
            if (this.namespace != null && this.namespace.length() > 0 && childName.indexOf(58) < 0) {
                childName = String.valueOf(this.namespace) + ":" + childName;
            }
            if ((child = XMLUtil.getFirstChild(element, childName)) != null) {
                return this.getAttribute(child, xmlname.substring(ind + 1), attr);
            }
        } else if (XMLUtil.hasAttribute(element, xmlname = this.applyNamespaceToAttribute(xmlname))) {
            return element.getAttribute(xmlname);
        }
        return null;
    }

    public void loadChildren(Element element, XModelObject o) {
        XModelEntity entity = o.getModelEntity();
        XModel model = o.getModel();
        Set<String> childset = entity.getRequiredChildren();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                XModelObject co;
                Element e = (Element)n;
                String en = this.getChildEntity(entity, e);
                if (en == null && entity.getChild(ENT_ANY_ELEMENT) != null) {
                    en = ENT_ANY_ELEMENT;
                }
                if (en != null && (co = model.createModelObject(en, null)) != null) {
                    this.load(e, co);
                    if (!o.addChild(co) && co.getFileType() == 0) {
                        String ppn;
                        String pp;
                        if (co.getModelEntity().getAttribute(ATTR_ID_NAME) != null) {
                            int k = 1;
                            pp = co.getPathPart();
                            while (o.getChildByPath(pp) != null) {
                                co.setAttributeValue(ATTR_ID_NAME, "" + k);
                                ppn = co.getPathPart();
                                if (ppn.equals(pp)) break;
                                pp = ppn;
                                ++k;
                            }
                            o.addChild(co);
                        } else if (o.isActive() || entity.getChild(en) != null && entity.getChild(en).isRequired()) {
                            try {
                                XModelObject q = o.getChildByPath(co.getPathPart());
                                if (q != null) {
                                    EnginesLoader.merge(q, co, false);
                                }
                            }
                            catch (XModelException exc) {
                                ModelPlugin.getPluginLog().logError("XModelObjectLoaderUtil:loadChildren:" + exc.getMessage(), (Throwable)((Object)exc));
                            }
                        } else {
                            int k = 1;
                            pp = co.getPathPart();
                            while (o.getChildByPath(pp) != null) {
                                co.set("__duplicate", "" + k);
                                ppn = co.getPathPart();
                                if (ppn.equals(pp)) break;
                                pp = ppn;
                                ++k;
                            }
                            o.addChild(co);
                        }
                    } else if (childset.contains(en)) {
                        childset.remove(en);
                    }
                }
            }
            ++i;
        }
        if (!childset.isEmpty()) {
            for (String en : childset) {
                o.addChild(XModelObjectLoaderUtil.createValidObject(model, en));
            }
        }
    }

    public static String getModelEntityAttribute(Element element) {
        if (XMLUtil.hasAttribute(element, XModelConstants.XMODEL_ENTITY_ATTR)) {
            return element.getAttribute(XModelConstants.XMODEL_ENTITY_ATTR);
        }
        if (XMLUtil.hasAttribute(element, XModelConstants.XMODEL_ENTITY_ATTR_OLD)) {
            return element.getAttribute(XModelConstants.XMODEL_ENTITY_ATTR_OLD);
        }
        return null;
    }

    protected String getChildEntity(XModelEntity entity, Element e) {
        String en = XModelObjectLoaderUtil.getModelEntityAttribute(e);
        if (en == null || en.length() == 0) {
            String n = e.getNodeName();
            if (this.namespaceMapping != null) {
                n = this.namespaceMapping.convertToDefault(n);
            }
            if (this.namespace != null && this.namespace.length() > 0 && n.startsWith(String.valueOf(this.namespace) + ":")) {
                n = n.substring(this.namespace.length() + 1);
            }
            en = entity.getChildByXML(n);
        }
        return en;
    }

    protected boolean acceptElement(Element e, String entity) {
        return !this.saveentity || entity.equals(e.getAttribute(XModelConstants.XMODEL_ENTITY_ATTR)) || entity.equals(e.getAttribute(XModelConstants.XMODEL_ENTITY_ATTR_OLD));
    }

    public static XModelObject createValidObject(XModel model, String entityname) {
        return XModelObjectLoaderUtil.createValidObject(model, entityname, null);
    }

    public static XModelObject createValidObject(XModel model, String entityname, Properties p) {
        XModelObject o = model.createModelObject(entityname, p);
        if (o != null) {
            XModelObjectLoaderUtil.addRequiredChildren(o);
        }
        return o;
    }

    public static void addRequiredChildren(XModelObject object) {
        XChild[] cs = object.getModelEntity().getChildren();
        int i = 0;
        while (i < cs.length) {
            XModelObject c;
            if (cs[i].getMaxCount() == 1 && cs[i].isRequired() && (c = XModelObjectLoaderUtil.createValidObject(object.getModel(), cs[i].getName(), null)) != null) {
                object.addChild(c);
            }
            ++i;
        }
    }

    public static void addRequiredChildren(XModelObject object, boolean onlyHavingNoXMLPath) {
        XChild[] cs = object.getModelEntity().getChildren();
        int i = 0;
        while (i < cs.length) {
            XModelObject c;
            String xml;
            XModelEntity e;
            if (cs[i].getMaxCount() == 1 && cs[i].isRequired() && (!onlyHavingNoXMLPath || (e = cs[i].getMetaModel().getEntity(cs[i].getName())) != null && ((xml = e.getXMLSubPath()) == null || xml.length() <= 0)) && (c = XModelObjectLoaderUtil.createValidObject(object.getModel(), cs[i].getName(), null)) != null) {
                object.addChild(c);
            }
            ++i;
        }
    }

    public boolean save(Element parent, XModelObject o) {
        if (ENT_ANY_ELEMENT.equals(o.getModelEntity().getName())) {
            this.saveAnyElement(parent, o);
            return true;
        }
        String xmlname = this.getXMLSubPath(o);
        if (xmlname == null || xmlname.trim().length() == 0) {
            return true;
        }
        if (this.namespaceMapping != null) {
            xmlname = this.namespaceMapping.convertToActual(xmlname);
        }
        if (this.namespace != null && this.namespace.length() > 0) {
            xmlname = String.valueOf(this.namespace) + ":" + xmlname;
        }
        Element element = XMLUtil.createElement(parent, xmlname);
        this.saveAttributes(element, o);
        boolean b = this.saveChildren(element, o);
        this.saveFinalComment(element, o);
        if (b) {
            o.setModified(false);
        }
        return b;
    }

    protected String getXMLSubPath(XModelObject o) {
        return o.getModelEntity().getXMLSubPath();
    }

    public void saveAttributes(Element element, XModelObject o) {
        XModelEntity entity = o.getModelEntity();
        XAttribute[] as = entity.getAttributes();
        if (this.saveentity) {
            element.setAttribute(XModelConstants.XMODEL_ENTITY_ATTR, entity.getName());
        }
        int i = 0;
        while (i < as.length) {
            if (!as[i].isFake()) {
                String n = as[i].getName();
                if ("attributes".equals(n) && "true".equals(as[i].getProperty("any"))) {
                    XModelObjectLoaderUtil.saveAnyAtributes(element, o);
                } else {
                    String v;
                    String xmlname = as[i].getXMLName();
                    if (xmlname != null && xmlname.length() != 0 && this.isSaveable(entity, n, v = o.getAttributeValue(n), as[i].getDefaultValue())) {
                        String cn;
                        Element child;
                        String comment;
                        this.saveAttribute(element, xmlname, v);
                        String commentName = XModelObjectLoaderUtil.getAttributeCommentName(xmlname);
                        if (commentName != null && (comment = o.get(commentName)) != null && comment.length() > 0 && (child = XMLUtilities.getLastChild((Element)element, (String)(cn = xmlname.substring(0, xmlname.indexOf(46))))) != null) {
                            XModelObjectLoaderUtil.setComment(child, comment);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void saveAttribute(Element element, String xmlname, String value) {
        if (xmlname.equals("CDATA")) {
            XModelObjectLoaderUtil.setCDATA(element, value);
        } else if (xmlname.equals("#text")) {
            XModelObjectLoaderUtil.setText(element, value);
        } else if (xmlname.equals("#comment")) {
            XModelObjectLoaderUtil.setComment(element, value);
        } else {
            int ind = xmlname.indexOf(46);
            if (ind > 0) {
                Element child;
                String childName = xmlname.substring(0, ind);
                if (this.namespaceMapping != null) {
                    childName = this.namespaceMapping.convertToActual(childName);
                }
                if (this.namespace != null && this.namespace.length() > 0 && childName.indexOf(58) < 0) {
                    childName = String.valueOf(this.namespace) + ":" + childName;
                }
                if ((child = XMLUtil.getFirstChild(element, childName)) == null) {
                    child = XMLUtil.createElement(element, childName);
                }
                this.saveAttribute(child, xmlname.substring(ind + 1), value);
            } else {
                xmlname = this.applyNamespaceToAttribute(xmlname);
                element.setAttribute(xmlname, value);
            }
        }
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null || v.length() == 0) {
            return false;
        }
        if (!v.equals(dv)) {
            return true;
        }
        return this.singular != null && this.singular.get(n) != null;
    }

    public void saveFinalComment(Element element, XModelObject o) {
        String data = o.get("#final-comment");
        if (data == null || data.length() == 0) {
            return;
        }
        Comment comm = element.getOwnerDocument().createComment(data);
        element.appendChild(comm);
    }

    public boolean saveChildren(Element element, XModelObject o) {
        XModelObject[] os = ((XModelObjectImpl)o).getChildrenForSave();
        boolean b = true;
        int i = 0;
        while (i < os.length) {
            if (!this.save(element, os[i])) {
                b = false;
            }
            ++i;
        }
        return b;
    }

    public XModelObject parse(XModel model, Reader reader) {
        Element element = XMLUtil.getElement(reader);
        if (element == null) {
            return null;
        }
        String entity = XModelObjectLoaderUtil.getModelEntityAttribute(element);
        XModelObject o = model.createModelObject(entity, null);
        this.load(element, o);
        return o;
    }

    public Element asElement(XModelObject o) {
        Element root = XMLUtil.createDocumentElement(o.getModelEntity().getXMLSubPath());
        this.saveAttributes(root, o);
        boolean b = this.saveChildren(root, o);
        return b ? root : null;
    }

    public static final void serialize(Element element, String filename) throws IOException {
        File f = new File(filename);
        if (f.exists() && !f.canWrite()) {
            return;
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f);
        XModelObjectLoaderUtil.serialize(element, (Writer)new BufferedWriter(fw));
        fw.close();
    }

    public static String getEncoding(String body) {
        if (body == null || body.length() == 0) {
            return null;
        }
        String encoding = FileUtil.getEncoding((String)body);
        if (encoding == null) {
            return null;
        }
        return FileUtil.validateEncoding((String)encoding, (String)"UTF-8");
    }

    public static OutputFormat createOutputFormat(String encoding) {
        return XMLUtilities.createOutputFormat((String)encoding);
    }

    public static final boolean serialize(Element element, Writer w) throws IOException {
        if (element == null) {
            return false;
        }
        XModelObjectLoaderUtil.serialize(element, new XMLSerializer(w, XModelObjectLoaderUtil.createOutputFormat("UTF-8")));
        w.close();
        return true;
    }

    public boolean serialize(XModelObject object, Writer w) throws XModelException, IOException {
        return XModelObjectLoaderUtil.serialize(this.asElement(object), w);
    }

    public static final boolean serialize(Element element, OutputStream w) throws IOException {
        if (element == null) {
            return false;
        }
        XModelObjectLoaderUtil.serialize(element, new XMLSerializer(w, XModelObjectLoaderUtil.createOutputFormat("UTF-8")));
        w.close();
        return true;
    }

    public boolean serialize(XModelObject object, OutputStream w) throws XModelException, IOException {
        return XModelObjectLoaderUtil.serialize(this.asElement(object), w);
    }

    public static void serialize(Element element, XMLSerializer serial) throws IOException {
        serial.asDOMSerializer();
        serial.serialize(element);
    }

    public static void serialize(Document document, XMLSerializer serial) throws IOException {
        serial.asDOMSerializer();
        serial.serialize(document);
    }

    public static final boolean serialize(Document document, Writer w) throws IOException {
        return XModelObjectLoaderUtil.serialize(document, w, null);
    }

    public static final boolean serialize(Document document, Writer w, String encoding) throws IOException, IOException {
        if (document == null) {
            return false;
        }
        XModelObjectLoaderUtil.serialize(document, new XMLSerializer(w, XModelObjectLoaderUtil.createOutputFormat(encoding)));
        w.close();
        return true;
    }

    public String asString(XModelObject object) {
        StringWriter w = new StringWriter();
        Object e = null;
        try {
            this.serialize(object, w);
            return w.toString();
        }
        catch (XModelException e1) {
            e = e1;
        }
        catch (IOException e2) {
            e = e2;
        }
        ModelPlugin.getPluginLog().logError("XModelObjectLoaderUtil:asString:" + ((Throwable)e).getMessage(), (Throwable)e);
        return "";
    }

    public static final String getCDATA(Element elem) {
        return XMLUtilities.getCDATA((Element)elem, (boolean)true);
    }

    public static final String getCDATA(Element elem, boolean trim) {
        return XMLUtilities.getCDATA((Element)elem, (boolean)trim);
    }

    public static final String getComment(Element elem) {
        StringBuffer sb = new StringBuffer();
        Node node = elem.getPreviousSibling();
        XModelObjectLoaderUtil.loadComment(sb, node);
        return sb.toString();
    }

    public static final String getFinalComment(Element elem) {
        StringBuffer sb = new StringBuffer();
        NodeList nl = elem.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return "";
        }
        Node node = nl.item(nl.getLength() - 1);
        XModelObjectLoaderUtil.loadComment(sb, node);
        return sb.toString();
    }

    static final void loadComment(StringBuffer sb, Node node) {
        while (node != null) {
            if (node.getNodeType() == 1) break;
            if (node.getNodeType() == 8) {
                if (sb.length() > 0) {
                    sb.insert(0, '\n');
                    sb.insert(0, ((Comment)node).getData());
                } else {
                    sb.append(((Comment)node).getData());
                }
            }
            node = node.getPreviousSibling();
        }
    }

    public static final void setCDATA(Element element, String data) {
        if (data == null) {
            data = "";
        }
        element.appendChild(element.getOwnerDocument().createCDATASection(data));
    }

    public static final void setText(Element element, String data) {
        if (data == null) {
            data = "";
        }
        element.appendChild(element.getOwnerDocument().createTextNode(data));
    }

    public static final void setComment(Element element, String data) {
        if (data == null) {
            data = "";
        }
        Comment comm = element.getOwnerDocument().createComment(data);
        element.getParentNode().insertBefore(comm, element);
    }

    public void load(File f, XModelObject o) {
        if (f == null || !f.isFile()) {
            return;
        }
        Element element = XMLUtil.getElement(f.getAbsolutePath());
        if (element != null) {
            this.load(element, o);
        }
    }

    public boolean save(File f, XModelObject o) {
        int i;
        if (f.exists() && !o.isModified()) {
            return true;
        }
        StringWriter w = new StringWriter();
        Object e = null;
        try {
            if (!this.serialize(o, w)) {
                return false;
            }
        }
        catch (XModelException e1) {
            e = e1;
        }
        catch (IOException e2) {
            e = e2;
        }
        if (e != null) {
            ModelPlugin.getPluginLog().logError("XModelObjectLoaderUtil:save(f,o):" + ((Throwable)e).getMessage(), (Throwable)e);
            return false;
        }
        String r = w.toString();
        boolean c = XModelObjectLoaderUtil.coincides(f, r);
        int n = i = c ? 0 : XModelObjectLoaderUtil.handleReadOnly(f, o);
        if (i != 0) {
            return i == 1;
        }
        if (!c) {
            XModelObjectLoaderUtil.writeFile(f, r);
        }
        o.setModified(false);
        return true;
    }

    public static boolean saveBody(File f, XModelObject o, String defaultEncoding) {
        int i;
        boolean same = FileUtil.isSameFile((File)f);
        if (same && !o.isModified()) {
            return true;
        }
        String r = XModelObjectLoaderUtil.getTempBody(o);
        boolean c = same && XModelObjectLoaderUtil.coincides(f, r);
        int n = i = c ? 0 : XModelObjectLoaderUtil.handleReadOnly(f, o);
        if (i != 0) {
            return i == 1;
        }
        if (!c && !FileUtil.writeFileWithEncodingCheck((File)f, (String)r, (String)defaultEncoding)) {
            return false;
        }
        o.setModified(false);
        return true;
    }

    public static int handleReadOnly(File f, XModelObject o) {
        int i = 0;
        while (i == 0 && f.exists() && !f.canWrite()) {
            i = o.getModel().getService().showDialog("Question", XModelObjectLoaderUtil.getReadOnlyMessage(f), new String[]{"Retry", "Discard", ModelMessages.Cancel}, null, 0);
        }
        return i;
    }

    public static String getReadOnlyMessage(File f) {
        return MessageFormat.format("Cannot save to read-only file {0}.", f.getAbsolutePath());
    }

    public static String getTempBody(XModelObject o) {
        String b = o.get("_body_");
        o.set("_body_", "");
        return b;
    }

    public static void setTempBody(XModelObject o, String body) {
        o.set("_body_", body);
    }

    private static String expandString(String s) {
        return Paths.expand(s, System.getProperties());
    }

    public static String readFile(String filename) {
        if (filename == null) {
            return "";
        }
        return XModelObjectLoaderUtil.readFile(new File(XModelObjectLoaderUtil.expandString(filename)));
    }

    public static String readFile(File f) {
        return FileUtil.readFile((File)f);
    }

    public static boolean isTextFile(File f, int length) {
        return FileUtil.isTextFile((File)f, (int)length);
    }

    public static boolean writeFile(String filename, String value) {
        if (filename == null) {
            return false;
        }
        return XModelObjectLoaderUtil.writeFile(new File(XModelObjectLoaderUtil.expandString(filename)), value);
    }

    public static boolean writeFile(File f, String value) {
        return FileUtil.writeFile((File)f, (String)value);
    }

    public static boolean coincides(File f, String value) {
        return f.isFile() && value != null && XModelObjectLoaderUtil.readFile(f).equals(value);
    }

    public static XObjectLoader getObjectLoader(XModelObject object) {
        if (object == null) {
            return null;
        }
        return object.getModelEntity().getObjectLoader();
    }

    public static void remove(File f) {
        FileUtil.remove((File)f);
    }

    public static final String getResourcePath(XModelObject object) {
        int t = object.getFileType();
        if (t == 3) {
            return "";
        }
        XModelObject p = object.getParent();
        if (p == null) {
            return null;
        }
        String n = t == 2 ? object.get("NAME") : (t == 1 ? FileAnyImpl.toFileName(object) : object.getPathPart());
        String pp = XModelObjectLoaderUtil.getResourcePath(p);
        return pp == null ? n : String.valueOf(pp) + "/" + n;
    }

    public static String loadFromXMLAttribute(String text) {
        StringBuffer sb = new StringBuffer();
        char[] c = text.toCharArray();
        boolean slash = false;
        int i = 0;
        while (i < c.length) {
            if (!slash) {
                if (c[i] != '\\') {
                    sb.append(c[i]);
                } else if (c[i] == '\\') {
                    slash = true;
                }
            } else {
                slash = false;
                if (c[i] == '\\') {
                    sb.append('\\');
                } else if (c[i] == 'n') {
                    sb.append('\n');
                } else if (c[i] == 't') {
                    sb.append('\t');
                } else {
                    sb.append('\\').append(c[i]);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String saveToXMLAttribute(String text) {
        StringBuffer sb = new StringBuffer();
        char[] c = text.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] != '\r') {
                if (c[i] == '\n') {
                    sb.append('\\').append('n');
                } else if (c[i] == '\\') {
                    sb.append('\\').append('\\');
                } else if (c[i] == '\t') {
                    sb.append('\\').append('t');
                } else {
                    sb.append(c[i]);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static void updateModifiedOnSave(XModelObject o) {
        if (!o.isModified()) {
            XModelObjectLoaderUtil.updateModifiedFlag(o.getParent());
        }
    }

    public static void updateModifiedFlag(XModelObject o) {
        if (o == null) {
            return;
        }
        XModelObject[] cs = o.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i].isModified()) {
                return;
            }
            ++i;
        }
        o.setModified(false);
        XModelObjectLoaderUtil.updateModifiedFlag(o.getParent());
    }

    protected void loadAnyElement(Element element, XModelObject o) {
        o.setAttributeValue("tag", element.getTagName());
        XModelObjectLoaderUtil.loadAnyAtributes(element, o);
        String text = this.getAttribute(element, "#text").trim();
        if (text.length() > 0) {
            while (text.startsWith("\n") || text.startsWith("\r")) {
                text = text.substring(1);
            }
            while (text.endsWith("\n") || text.endsWith("\r")) {
                text = text.substring(0, text.length() - 1);
            }
            o.setAttributeValue("text", text);
        }
        this.loadChildren(element, o);
    }

    public static void loadAnyAtributes(Element element, XModelObject o) {
        XAttribute[] oas;
        HashSet<String> attrs = new HashSet<String>();
        XAttribute[] xAttributeArray = oas = o.getModelEntity().getAttributes();
        int n = oas.length;
        int n2 = 0;
        while (n2 < n) {
            XAttribute a = xAttributeArray[n2];
            String xml = a.getXMLName();
            if (xml != null && xml.length() > 0) {
                attrs.add(xml);
            }
            ++n2;
        }
        StringBuffer sb = new StringBuffer();
        NamedNodeMap as = element.getAttributes();
        int i = 0;
        while (i < as.getLength()) {
            String v;
            Node n3 = as.item(i);
            String nm = n3.getNodeName();
            if (!attrs.contains(nm) && (v = n3.getNodeValue()) != null) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(nm).append("=").append(v);
            }
            ++i;
        }
        o.setAttributeValue("attributes", sb.toString());
    }

    protected void saveAnyElement(Element parent, XModelObject o) {
        String xmlname = o.getAttributeValue("tag");
        if (xmlname == null || xmlname.trim().length() == 0) {
            return;
        }
        if (this.namespace != null && this.namespace.length() > 0) {
            xmlname = String.valueOf(this.namespace) + ":" + xmlname;
        }
        Element element = XMLUtil.createElement(parent, xmlname);
        XModelObjectLoaderUtil.saveAnyAtributes(element, o);
        String text = o.getAttributeValue("text");
        if (text != null && text.length() > 0) {
            this.saveAttribute(element, "#text", text);
        }
        XModelObject[] cs = o.getChildren();
        int i = 0;
        while (i < cs.length) {
            this.saveAnyElement(element, cs[i]);
            ++i;
        }
    }

    public static void saveAnyAtributes(Element element, XModelObject o) {
        String attrs = o.getAttributeValue("attributes");
        StringTokenizer st = new StringTokenizer(attrs, ";");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            int i = t.indexOf(61);
            if (i < 0) continue;
            String n = t.substring(0, i);
            String v = t.substring(i + 1);
            element.setAttribute(n, v);
        }
    }

    protected void eitherOr(Element element, String attr1, String attr2) {
        Element e1 = XMLUtil.getUniqueChild(element, attr1);
        Element e2 = XMLUtil.getUniqueChild(element, attr2);
        if (e1 != null && e2 != null) {
            element.removeChild(e2);
        }
    }

    protected void saveArray(Element element, String xmlname, String value) {
        String[] ns = XModelObjectUtil.asStringArray(value);
        if (this.namespaceMapping != null) {
            xmlname = this.namespaceMapping.convertToActual(xmlname);
        }
        if (this.namespace != null && this.namespace.length() > 0 && xmlname.indexOf(58) < 0) {
            xmlname = String.valueOf(this.namespace) + ":" + xmlname;
        }
        int i = 0;
        while (i < ns.length) {
            Element c = XMLUtil.createElement(element, xmlname);
            this.saveAttribute(c, "#text", ns[i]);
            ++i;
        }
    }

    protected String loadArray(Element element, String xmlname) {
        Element[] es = XMLUtil.getChildren(element, xmlname);
        if (es == null || es.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < es.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getAttribute(es[i], "#text"));
            ++i;
        }
        return sb.toString();
    }

    public static void mergeAttributes(XModelObject destination, XModelObject source) throws XModelException {
        XModelObjectLoaderUtil.mergeAttributes(destination, source, destination.isActive());
    }

    public static void mergeAttributes(XModelObject destination, XModelObject source, boolean fire) throws XModelException {
        XAttribute[] as = destination.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String n = as[i].getName();
            if (as[i].isCopyable()) {
                XModelObjectLoaderUtil.mergeAttributeComment(destination, source, as[i], fire);
                String ov = destination.getAttributeValue(n);
                String nv = source.getAttributeValue(n);
                if (!(nv == null || ov != null && ov.equals(nv))) {
                    if (fire) {
                        destination.getModel().changeObjectAttribute(destination, n, nv);
                    } else {
                        destination.setAttributeValue(n, nv);
                    }
                }
            }
            ++i;
        }
        XModelObjectLoaderUtil.mergeFinalComment(destination, source, fire);
        String d = destination.get("__duplicate");
        if (d != null && d.length() > 0) {
            destination.set("__duplicate", "");
        }
    }

    public static void mergeAttributeComment(XModelObject destination, XModelObject source, XAttribute attr, boolean fire) {
        String commentName = XModelObjectLoaderUtil.getAttributeCommentName(attr.getXMLName());
        XModelObjectLoaderUtil.mergeComment(destination, source, commentName, fire);
    }

    private static String getAttributeCommentName(String xmlname) {
        if (xmlname != null && xmlname.indexOf(46) > 0 && !xmlname.endsWith("#comment")) {
            return String.valueOf(xmlname) + ".#comment";
        }
        return null;
    }

    public static void mergeFinalComment(XModelObject destination, XModelObject source, boolean fire) {
        String commentName = "#final-comment";
        XModelObjectLoaderUtil.mergeComment(destination, source, commentName, fire);
    }

    static void mergeComment(XModelObject destination, XModelObject source, String commentName, boolean fire) {
        if (commentName == null) {
            return;
        }
        String newComment = source.get(commentName);
        String oldComment = destination.get(commentName);
        String set = null;
        if (newComment == null || newComment.length() == 0) {
            if (oldComment != null && oldComment.length() > 0) {
                set = "";
            }
        } else if (oldComment == null || !oldComment.equals(newComment)) {
            set = newComment;
        }
        if (set != null) {
            destination.set(commentName, set);
            if (fire) {
                XModelImpl impl = (XModelImpl)destination.getModel();
                impl.fireNodeChanged(destination, destination.getPath());
            }
        }
    }
}

