/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.PositionSearcher;

public class PositionHolder {
    static String POSITION_HOLDER_ID = "positionHolder";
    private XModelObject object;
    private String attribute;
    private FileAnyImpl file = null;
    private long fileTimeStamp = -1L;
    private int start;
    private int end;
    private int line;

    public static PositionHolder getPosition(XModelObject object, String attribute) {
        String id = attribute == null ? POSITION_HOLDER_ID : String.valueOf(POSITION_HOLDER_ID) + "." + attribute;
        PositionHolder h = (PositionHolder)object.getObject(id);
        if (h == null) {
            h = new PositionHolder(object, attribute);
            object.setObject(id, h);
        }
        return h;
    }

    private PositionHolder(XModelObject object, String attribute) {
        this.object = object;
        this.attribute = attribute;
    }

    public void update() {
        long ts;
        if (!this.object.isActive()) {
            if (this.file == null) {
                return;
            }
            this.file = null;
        } else if (this.file == null) {
            XModelObject f = this.object;
            while (f != null && f.getFileType() != 1) {
                f = f.getParent();
            }
            if (f instanceof FileAnyImpl) {
                this.file = (FileAnyImpl)f;
            }
        }
        if (this.file == null) {
            this.fileTimeStamp = -1L;
            this.start = -1;
            this.end = -1;
            this.line = -1;
            return;
        }
        long l = ts = this.file == null ? -1L : this.file.getTimeStamp();
        if (ts == this.fileTimeStamp) {
            return;
        }
        this.fileTimeStamp = ts;
        String text = this.file.getAsText();
        PositionSearcher searcher = new PositionSearcher();
        searcher.init(text, this.object, this.attribute);
        searcher.execute();
        this.start = searcher.getStartPosition();
        this.end = searcher.getEndPosition();
        this.line = this.computeLine(text, this.start);
    }

    private int computeLine(String text, int pos) {
        if (pos < 0) {
            return -1;
        }
        int line = 1;
        boolean q = false;
        int i = 0;
        while (i < text.length() && i < pos) {
            char ch = text.charAt(i);
            if (ch == '\n' || q) {
                ++line;
            }
            q = ch == '\r';
            ++i;
        }
        return line;
    }

    public int getLine() {
        return this.line;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

