/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.undo;

import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.util.IconUtil;

public abstract class XUndoableImpl
implements XUndoable {
    public static final int EDIT = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    protected int kind;
    protected XUndoableImpl next = null;
    protected XUndoableImpl prev = null;
    protected boolean undone = false;
    protected String description = "";
    protected Image icon = null;

    public void setNext(XUndoableImpl next) {
        this.next = next;
        if (next != null) {
            next.prev = this;
        }
    }

    public XUndoableImpl prev() {
        return this.prev;
    }

    public XUndoableImpl next() {
        return this.next;
    }

    @Override
    public void undo() {
        this.doUndo();
        this.undone = true;
    }

    @Override
    public void redo() {
        this.doRedo();
        this.undone = false;
    }

    @Override
    public boolean canUndo() {
        return !this.undone;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    protected abstract void doUndo();

    protected abstract void doRedo();

    public String getDescription() {
        return this.description;
    }

    public Image[] icons() {
        return new Image[]{IconUtil.getEclipseImage(this.getActionIcon()), this.icon};
    }

    protected String getActionIcon() {
        return this.kind == 1 ? "images/java/newattribute.gif" : (this.kind == 2 ? "images/actions/delete.gif" : "images/file/redhat_file.gif");
    }

    protected boolean merge(XUndoableImpl u) {
        return false;
    }
}

