/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.undo;

import java.util.ArrayList;
import org.jboss.tools.common.model.undo.XUndoItem;
import org.jboss.tools.common.model.undo.XUndoManager;

public class XUndoList {
    private XUndoManager manager = null;
    private ArrayList<XUndoItem> items = new ArrayList(0);
    private int current = 0;
    private boolean isCurrentUndone = false;

    public XUndoList(XUndoManager manager) {
        this.manager = manager;
    }

    public XUndoItem[] items() {
        return this.items.toArray(new XUndoItem[this.items.size()]);
    }

    public int getLastUndone() {
        return this.isCurrentUndone ? this.current : this.current + 1;
    }

    public void execute(int i) {
        if (i == this.current) {
            if (this.isCurrentUndone) {
                this.manager.redo();
            } else {
                this.manager.undo();
            }
            this.isCurrentUndone = !this.isCurrentUndone;
        } else if (i < this.current) {
            if (this.isCurrentUndone) {
                --this.current;
            }
            int j = this.current;
            while (j >= i) {
                this.manager.undo();
                --j;
            }
            this.isCurrentUndone = true;
        } else if (i > this.current) {
            if (!this.isCurrentUndone) {
                ++this.current;
            }
            int j = this.current;
            while (j <= i) {
                this.manager.redo();
                ++j;
            }
            this.isCurrentUndone = false;
        }
        this.current = i;
    }

    void add(XUndoItem item) {
        this.items.add(item);
    }

    void setCurrent(int current) {
        this.current = current;
        if (current < 0) {
            current = 0;
            this.isCurrentUndone = true;
        }
    }
}

