/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.search.impl;

import java.util.ArrayList;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.search.SearchCommand;
import org.jboss.tools.common.model.search.SearchConstraint;
import org.jboss.tools.common.model.search.impl.SearchConstraintImpl;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class SearchCommandImpl
extends SearchConstraintImpl
implements SearchCommand {
    private static final long serialVersionUID = 1L;
    protected SearchConstraint matching;
    protected SearchConstraint insight;

    @Override
    public void prepare() {
        super.prepare();
        this.matching = (SearchConstraint)((Object)this.getChildren("SearchMatch")[0]);
        this.insight = (SearchConstraint)((Object)this.getChildren("SearchRecursion")[0]);
    }

    @Override
    public XModelObject[] execute() {
        XModelObject root;
        int i;
        this.prepare();
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        String[] roots = XModelObjectUtil.asStringArray(this.getAttributeValue("root"));
        ArrayList<XModelObject> os = new ArrayList<XModelObject>();
        if (roots.length == 0) {
            os.add(this.getModel().getRoot());
        } else {
            i = 0;
            while (i < roots.length) {
                root = this.getModel().getByPath(roots[i]);
                if (root != null) {
                    os.add(root);
                }
                ++i;
            }
        }
        i = 0;
        while (i < os.size()) {
            root = (XModelObject)os.get(i);
            this.execute(root, list);
            ++i;
        }
        return list.toArray(new XModelObject[list.size()]);
    }

    @Override
    public void validate() {
        String rootpath = this.getAttributeValue("root");
        if (rootpath.length() == 0) {
            throw new IllegalStateException("Attribute 'root' of search command must be set.");
        }
        XModelObject root = this.getModel().getByPath(rootpath);
        if (root == null) {
            throw new IllegalStateException("Root of search command is not found in model.");
        }
    }

    protected void execute(XModelObject o, ArrayList<XModelObject> list) {
        if (this.matching.accepts(o)) {
            list.add(o);
        }
        if (this.insight.accepts(o)) {
            XModelObject[] os = ((XModelObjectImpl)o).getChildrenForSave();
            int i = 0;
            while (i < os.length) {
                this.execute(os[i], list);
                ++i;
            }
        }
    }
}

