/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.refactoring;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class RefactoringHelper {
    public static void addChanges(XModelObject fileObject, Properties replacements, CompositeChange parentChange) {
        if (replacements == null || replacements.size() == 0) {
            return;
        }
        IFile f = (IFile)EclipseResourceUtil.getResource(fileObject);
        if (f == null) {
            return;
        }
        String body = ((FileAnyImpl)fileObject).getAsText();
        if (body == null || replacements.size() == 0) {
            return;
        }
        ReplaceEdit[] edits = RefactoringHelper.getEdits(replacements, body);
        if (edits != null && edits.length > 0) {
            TextFileChange change = new TextFileChange("TextFileChange", f);
            int j = 0;
            while (j < edits.length) {
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)"Update Reference", (TextEdit)edits[j]);
                ++j;
            }
            parentChange.add((Change)change);
        }
    }

    public static ReplaceEdit[] getEdits(Properties replacements, String body) {
        ArrayList<ReplaceEdit> l = new ArrayList<ReplaceEdit>();
        String[] bs = replacements.keySet().toArray(new String[0]);
        int i = 0;
        while (i < bs.length) {
            String b = bs[i];
            int length = b.length();
            String e = replacements.getProperty(b);
            int pos = 0;
            while ((pos = body.indexOf(b, pos)) >= 0) {
                ReplaceEdit edit = new ReplaceEdit(pos, length, e);
                l.add(edit);
                pos += length;
            }
            ++i;
        }
        return l.toArray(new ReplaceEdit[0]);
    }
}

