/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Element;

public class DefaultEntityLoader
implements XObjectLoader {
    protected static XModelObjectLoaderUtil util = new XModelObjectLoaderUtil();

    @Override
    public void load(XModelObject object) {
        String body = XModelObjectLoaderUtil.getTempBody(object);
        Element e = XMLUtil.getElement(new StringReader(body));
        if (e != null) {
            this.util().load(e, object);
        }
    }

    @Override
    public boolean update(XModelObject object) throws XModelException {
        XModelObject c = object.copy(0);
        XModelObjectLoaderUtil.setTempBody(c, XModelObjectLoaderUtil.getTempBody(object));
        this.load(c);
        XModelObject p = object.getParent();
        p.removeChild(object);
        p.addChild(c);
        c.setModified(false);
        return true;
    }

    @Override
    public boolean save(XModelObject object) {
        StringWriter sw;
        block5: {
            if (!object.isModified()) {
                return true;
            }
            sw = new StringWriter();
            if (this.util().serialize(object, sw)) break block5;
            return false;
        }
        try {
            XModelObjectLoaderUtil.setTempBody(object, sw.toString());
            object.setModified(true);
            return true;
        }
        catch (IOException exc) {
            ModelPlugin.getPluginLog().logError("DefaultEntityLoader:save(" + object.getPresentationString() + "):" + exc.getMessage());
            return false;
        }
        catch (XModelException e2) {
            ModelPlugin.getPluginLog().logError("DefaultEntityLoader:save(" + object.getPresentationString() + "):" + e2.getMessage());
            return false;
        }
    }

    protected XModelObjectLoaderUtil util() {
        return util;
    }
}

