/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.model.filesystems.impl.JarAccess;

public class TestJarAccess {
    int threadCount = 10;
    JarAccess acc = new JarAccess();
    List<String> errors = new ArrayList<String>();

    public TestJarAccess(String location) {
        this.acc.setLocation(location);
    }

    public void runAll() {
        Thread[] ts = new Thread[this.threadCount];
        int i = 0;
        while (i < this.threadCount) {
            Runner r = new Runner(i);
            Thread t = new Thread(r);
            t.start();
            ts[i] = t;
            ++i;
        }
        boolean b = true;
        while (b) {
            b = false;
            int i2 = 0;
            while (i2 < this.threadCount) {
                if (ts[i2].isAlive()) {
                    b = true;
                }
                ++i2;
            }
            if (!b) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getErrors() {
        this.errors.addAll(this.acc.getErrors());
        return this.errors;
    }

    void readAllFiles(String path) {
        String parentPath;
        String[] ps = this.acc.getChildren(path);
        String string = parentPath = path.length() == 0 ? "" : String.valueOf(path) + "/";
        if (ps != null) {
            int i = 0;
            while (i < ps.length) {
                boolean d = ps[i].endsWith("/");
                if (d) {
                    ps[i] = ps[i].substring(0, ps[i].length() - 1);
                }
                if (d) {
                    this.readAllFiles(String.valueOf(parentPath) + ps[i]);
                } else {
                    this.acc.getContent(String.valueOf(parentPath) + ps[i]);
                }
                ++i;
            }
        }
    }

    class Runner
    implements Runnable {
        int id;

        public Runner(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (i < 100) {
                    TestJarAccess.this.readAllFiles("");
                    ++i;
                }
            }
            catch (Exception e) {
                TestJarAccess.this.errors.add(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            }
        }
    }
}

