/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;

class LinkedResources {
    protected Map<String, File> filesByLinkName = new HashMap<String, File>();
    protected Map<String, File> filesByFileName = new HashMap<String, File>();
    protected Map<String, IResource> resourcesByLinkName = new HashMap<String, IResource>();
    protected Map<String, IResource> resourcesByFileName = new HashMap<String, IResource>();

    LinkedResources() {
    }

    public boolean containsFile(String name) {
        return this.filesByFileName.containsKey(name);
    }

    public File getFileByResourceName(String name) {
        return this.filesByLinkName.get(name);
    }

    public File getFileByFileName(String name) {
        return this.filesByFileName.get(name);
    }

    public IResource getResourceByResourceName(String name) {
        return this.resourcesByLinkName.get(name);
    }

    public IResource getResourceByFileName(String name) {
        return this.resourcesByFileName.get(name);
    }

    public void registerResource(IResource r) {
        File f = FolderImpl.toFile(r);
        String pp = FilePathHelper.toPathPath(f.getName());
        this.filesByFileName.put(pp, f);
        this.filesByLinkName.put(r.getName(), f);
        this.resourcesByFileName.put(pp, r);
        this.resourcesByLinkName.put(r.getName(), r);
    }

    public void clearFiles() {
        this.filesByFileName.clear();
        this.filesByLinkName.clear();
    }
}

