/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.Comparator;
import java.util.Properties;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.BodySource;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FileObjectComparator;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderLoader;
import org.jboss.tools.common.model.filesystems.impl.JarAccess;
import org.jboss.tools.common.model.filesystems.impl.JarBodySource;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class JarFolderImpl
extends RegularObjectImpl
implements FolderLoader {
    private static final long serialVersionUID = 7958999905551184060L;
    protected boolean loaded = false;
    protected boolean fire = false;

    @Override
    public int getFileType() {
        return 2;
    }

    @Override
    protected Comparator<XModelObject> createComparator() {
        return new FileObjectComparator();
    }

    protected JarSystemImpl getJarSystem() {
        JarFolderImpl folder = (JarFolderImpl)this.getParent();
        return folder == null ? null : folder.getJarSystem();
    }

    @Override
    public boolean isObjectEditable() {
        return false;
    }

    protected String getAbsolutePath() {
        String p;
        String string = p = this.getParent() == null ? null : ((JarFolderImpl)this.getParent()).getAbsolutePath();
        if (p != null && p.length() > 0) {
            p = String.valueOf(p) + "/";
        }
        return p == null ? null : String.valueOf(p) + this.name();
    }

    @Override
    public BodySource getBodySource(String filename) {
        String path = this.getAbsolutePath();
        if (path == null) {
            return null;
        }
        String cpath = path.length() == 0 ? filename : String.valueOf(path) + "/" + filename;
        return new JarBodySource(this.getJarSystem().getJarAccess(), cpath);
    }

    @Override
    protected void loadChildren() {
        if (this.loaded || !this.isActive()) {
            return;
        }
        JarAccess jar = this.getJarSystem().getJarAccess();
        if (!jar.isLoaded()) {
            return;
        }
        jar.lockJar();
        String path = this.getAbsolutePath();
        String[] cs = jar.getChildren(path);
        Properties p = new Properties();
        int i = 0;
        while (i < cs.length && !this.loaded) {
            boolean d = cs[i].endsWith("/");
            if (d) {
                cs[i] = cs[i].substring(0, cs[i].length() - 1);
            }
            if (this.children.getObject(FilePathHelper.toPathPath(cs[i])) == null) {
                if (d) {
                    p.clear();
                    p.setProperty("name", cs[i]);
                    XModelObject c = this.getModel().createModelObject("JarFolder", p);
                    this.addChild(c);
                } else {
                    this.createFileObject(jar, path, cs[i], true);
                }
            }
            ++i;
        }
        this.fire = true;
        jar.unlockJar();
        this.loaded = true;
    }

    private XModelObject createFileObject(JarAccess jar, String path, String name, boolean add) {
        XModelObject c;
        String cpath = path.length() == 0 ? name : String.valueOf(path) + "/" + name;
        Properties p = new Properties();
        FolderImpl.parseFileName(p, name);
        String ext = p.getProperty("extension");
        String body = null;
        String entity = this.getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext(name, ext, body));
        if ("FileAny".equals(entity)) {
            if (jar.getSize(cpath) > 100000L) {
                entity = "FileAnyLong";
            } else if (jar.isTextEntry(cpath, 100)) {
                entity = "FileTXT";
            }
        } else if (!"FileCLASS".equals(entity)) {
            body = jar.getContent(cpath);
            entity = this.getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext(name, ext, body));
        }
        if (entity == null || this.getModel().getMetaData().getEntity(entity) == null) {
            entity = "FileAny";
        }
        if (FolderImpl.isLateloadFile2(c = this.getModel().createModelObject(entity, p))) {
            FileAnyImpl ci = (FileAnyImpl)c;
            ci.setBodySource(new JarBodySource(jar, cpath));
        } else {
            XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(c);
            if (loader != null) {
                if (body == null) {
                    body = jar.getContent(cpath);
                }
                XModelObjectLoaderUtil.setTempBody(c, body);
                loader.load(c);
            }
        }
        if (add) {
            this.addChild(c);
        } else {
            ((XModelObjectImpl)c).setParent_0(this);
        }
        return c;
    }

    public XModelObject createValidChildCopy(XModelObject child) {
        JarAccess jar = this.getJarSystem().getJarAccess();
        if (!jar.isLoaded()) {
            return null;
        }
        jar.lockJar();
        String path = this.getAbsolutePath();
        String item = FileAnyImpl.toFileName(child);
        XModelObject copy = this.createFileObject(jar, path, item, false);
        jar.unlockJar();
        return copy;
    }

    @Override
    protected void fireStructureChanged(int kind, Object info) {
        if (this.fire) {
            super.fireStructureChanged(kind, info);
        }
    }

    @Override
    public boolean hasChildren() {
        boolean q = super.hasChildren();
        if (q || this.loaded) {
            return q;
        }
        this.loadChildren();
        return super.hasChildren();
    }

    @Override
    public String getPathPart() {
        String s = super.getPathPart();
        return FilePathHelper.toPathPath(s);
    }

    @Override
    public XModelObject getChildByPathPart(String pathpart) {
        pathpart = FilePathHelper.toPathPath(pathpart);
        return super.getChildByPathPart(pathpart);
    }

    @Override
    public boolean update() {
        return true;
    }

    @Override
    public boolean save() {
        return true;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }
}

