/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.BodySource;
import org.jboss.tools.common.model.filesystems.impl.FileAnyAuxiliaryImpl;

public class FileAuxiliary {
    public static String AUX_FILE_ENTITY = "FileAnyAuxiliary";
    String extension = "";
    boolean replaceExtension = true;
    boolean addLeadingDot = true;

    public FileAuxiliary(String extension, boolean replaceExtension) {
        this.extension = extension;
        this.replaceExtension = replaceExtension;
    }

    public String read(XModelObject folder, XModelObject main) {
        FileAnyAuxiliaryImpl f = this.getAuxiliaryFile(folder, main, false);
        if (f == null) {
            return null;
        }
        BodySource bs = f.getBodySource();
        return bs == null ? null : bs.get();
    }

    public boolean write(XModelObject folder, XModelObject main, XModelObject object) {
        FileAnyAuxiliaryImpl f = this.getAuxiliaryFile(folder, main, true);
        if (f == null) {
            return false;
        }
        BodySource bs = f.getBodySource();
        return bs != null && bs.write(object);
    }

    public FileAnyAuxiliaryImpl getAuxiliaryFile(XModelObject folder, XModelObject main, boolean create) {
        if (folder == null) {
            return null;
        }
        String name = this.getAuxiliaryName(main);
        String p = String.valueOf(name) + "." + this.extension;
        XModelObject f = folder.getChildByPath(p);
        if (!(f instanceof FileAnyAuxiliaryImpl)) {
            if (!create) {
                return null;
            }
            f = folder.getModel().createModelObject(AUX_FILE_ENTITY, null);
            f.setAttributeValue("name", name);
            f.setAttributeValue("extension", this.extension);
            folder.addChild(f);
        }
        FileAnyAuxiliaryImpl aux = (FileAnyAuxiliaryImpl)f;
        aux.setMainObject(main);
        aux.setAuxiliaryHelper(this);
        return aux;
    }

    public String getMainName(XModelObject aux) {
        String s;
        String auxname = aux.getAttributeValue("name");
        if (this.replaceExtension) {
            return auxname;
        }
        int i = auxname.lastIndexOf(46);
        String string = s = i < 0 ? auxname : auxname.substring(0, i);
        if (this.addLeadingDot && s.startsWith(".")) {
            s = s.substring(1);
        }
        return s;
    }

    public String getAuxiliaryName(XModelObject main) {
        String name = main.getAttributeValue("name");
        if (!this.replaceExtension) {
            name = String.valueOf(name) + "." + main.getAttributeValue("extension");
        }
        if (this.addLeadingDot) {
            name = "." + name;
        }
        return name;
    }
}

