/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.event;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelChangeListener;

class OLBind {
    private XModelObject object = null;
    private String path = null;
    XModelChangeListener listener = null;
    private long timestamp = 0L;

    public OLBind(XModelObject object, XModelChangeListener listener) {
        this.object = object;
        this.path = object.getPath();
        this.timestamp = object.getTimeStamp();
        this.listener = listener;
    }

    public void fire() {
        if (this.isDead()) {
            return;
        }
        XModelObject o = this.object;
        if (!this.object.isActive()) {
            this.object = this.object.getModel().getByPath(this.path);
        }
        if (this.isDead()) {
            this.listener.delete(o);
        } else if (this.timestamp != this.object.getTimeStamp()) {
            this.timestamp = this.object.getTimeStamp();
            this.path = this.object.getPath();
            this.listener.update(this.object);
        }
    }

    public boolean isDead() {
        return this.object == null;
    }

    public boolean canFire() {
        if (this.isDead()) {
            return false;
        }
        return !this.object.isActive() || this.timestamp != this.object.getTimeStamp();
    }

    public boolean equals(OLBind bind) {
        return this.object == bind.object && this.listener == bind.listener;
    }
}

