/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ResourceTransfer;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class CopyHandler
extends AbstractHandler {
    static Transfer modelTransfer = (Transfer)ModelFeatureFactory.getInstance().createFeatureInstance("org.jboss.tools.common.model.ui.dnd.ModelTransfer");

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        object.getModel().getModelBuffer().clear();
        object.getModel().getModelBuffer().addSource(object);
        if (p == null || !"true".equals(p.getProperty("isDrag"))) {
            this.setClipboard(object.getModel());
        }
    }

    @Override
    public boolean getSignificantFlag(XModelObject object) {
        return false;
    }

    @Override
    public boolean isEnabled(XModelObject object) {
        return object != null;
    }

    @Override
    public void executeHandler(XModelObject object, XModelObject[] objects, Properties p) throws XModelException {
        if (!this.isEnabled(object, objects)) {
            return;
        }
        XModelBuffer buffer = object.getModel().getModelBuffer();
        buffer.clear();
        int i = 0;
        while (i < objects.length) {
            buffer.addSource(objects[i]);
            ++i;
        }
        if (p == null || !"true".equals(p.getProperty("isDrag"))) {
            this.setClipboard(object.getModel());
        }
    }

    @Override
    public void setDefaultData(XModelObject object) {
    }

    void setClipboard(XModel model) {
        Transfer[] transferArray;
        XModelBuffer buffer = model.getModelBuffer();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        ArrayList<String> files = new ArrayList<String>();
        StringBuffer texts = new StringBuffer();
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < buffer.getSize()) {
            XModelObject o = buffer.source(i);
            IResource resource = (IResource)o.getAdapter(IResource.class);
            if (resource instanceof IFile || resource instanceof IContainer) {
                resources.add(resource);
            }
            if (texts.length() > 0) {
                texts.append(' ');
            }
            texts.append(o.getPresentationString());
            if (resource instanceof IFile) {
                files.add(resource.getLocation().toOSString());
            }
            paths.add(o.getPath());
            ++i;
        }
        Clipboard c = new Clipboard(Display.getCurrent());
        ArrayList<Object> dataList = new ArrayList<Object>();
        dataList.add(resources.toArray(new IResource[0]));
        if (files.size() > 0) {
            dataList.add(files.toArray(new String[0]));
        }
        dataList.add(texts.toString());
        dataList.add(paths.toArray(new String[0]));
        Object[] data = dataList.toArray(new Object[0]);
        if (files.size() > 0) {
            Transfer[] transferArray2 = new Transfer[4];
            transferArray2[0] = ResourceTransfer.getInstance();
            transferArray2[1] = FileTransfer.getInstance();
            transferArray2[2] = TextTransfer.getInstance();
            transferArray = transferArray2;
            transferArray2[3] = modelTransfer;
        } else {
            Transfer[] transferArray3 = new Transfer[3];
            transferArray3[0] = ResourceTransfer.getInstance();
            transferArray3[1] = TextTransfer.getInstance();
            transferArray = transferArray3;
            transferArray3[2] = modelTransfer;
        }
        Transfer[] t = transferArray;
        c.setContents(data, t);
    }
}

