/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteInputStream;
import org.jboss.marshalling.UTFUtils;

public class SimpleDataInput
extends ByteInputStream
implements DataInput {
    protected final byte[] buffer;
    protected int position;
    protected int limit;

    public SimpleDataInput(int bufferSize) {
        this(bufferSize, null);
    }

    public SimpleDataInput(int bufferSize, ByteInput byteInput) {
        super(byteInput);
        this.buffer = new byte[bufferSize];
        this.byteInput = byteInput;
    }

    public SimpleDataInput(ByteInput byteInput) {
        this(8192, byteInput);
    }

    @Override
    public int read() throws IOException {
        int limit = this.limit;
        if (limit == -1) {
            return -1;
        }
        int position = this.position;
        byte[] buffer = this.buffer;
        if (position == limit) {
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                this.position = 0;
                return -1;
            }
            this.position = 1;
            return buffer[0] & 0xFF;
        }
        this.position = position + 1;
        return buffer[position] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int limit = this.limit;
        if (limit == -1) {
            return -1;
        }
        int position = this.position;
        int remaining = limit - position;
        if (remaining == 0) {
            return this.byteInput.read(b, off, len);
        }
        byte[] buffer = this.buffer;
        if (len > remaining) {
            System.arraycopy(buffer, position, b, off, remaining);
            this.position = 0;
            this.limit = 0;
            int res = this.byteInput.read(b, off + remaining, len - remaining);
            return res == -1 ? remaining : res + remaining;
        }
        System.arraycopy(buffer, position, b, off, len);
        this.position += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n < 0");
        }
        int limit = this.limit;
        if (limit == -1) {
            return 0L;
        }
        long remaining = limit - this.position;
        if (remaining > n) {
            this.position += (int)n;
            return n;
        }
        this.limit = 0;
        this.position = 0;
        return this.byteInput.skip(n - remaining) + remaining;
    }

    @Override
    public int available() throws IOException {
        return this.limit - this.position + this.byteInput.available();
    }

    private static EOFException eofOnRead() {
        return new EOFException("Read past end of file");
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.limit == -1) {
            throw SimpleDataInput.eofOnRead();
        }
        int position = this.position;
        int remaining = this.limit - position;
        if (len > remaining) {
            if (remaining > 0) {
                System.arraycopy(this.buffer, position, b, off, remaining);
                this.position = 0;
                this.limit = 0;
                off += remaining;
                len -= remaining;
            }
            ByteInput byteInput = this.byteInput;
            do {
                if ((remaining = byteInput.read(b, off, len)) == -1) {
                    throw SimpleDataInput.eofOnRead();
                }
                off += remaining;
            } while ((len -= remaining) != 0);
        } else {
            try {
                System.arraycopy(this.buffer, position, b, off, len);
                this.position = position + len;
            }
            catch (NullPointerException e) {
                throw SimpleDataInput.eofOnRead();
            }
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        int limit = this.limit;
        if (limit == -1) {
            return 0;
        }
        int remaining = limit - this.position;
        if (remaining > n) {
            this.position += n;
            return n;
        }
        this.limit = 0;
        this.position = 0;
        return (int)(this.byteInput.skip(n - remaining) + (long)remaining);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int position;
        int limit = this.limit;
        if (limit == -1) {
            throw SimpleDataInput.eofOnRead();
        }
        byte[] buffer = this.buffer;
        if ((position = this.position++) == limit) {
            this.position = 1;
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                throw SimpleDataInput.eofOnRead();
            }
            return buffer[0] != 0;
        }
        this.position = position + 1;
        return buffer[position] != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int position;
        int limit = this.limit;
        if (limit == -1) {
            throw SimpleDataInput.eofOnRead();
        }
        byte[] buffer = this.buffer;
        if ((position = this.position++) == limit) {
            this.position = 1;
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                throw SimpleDataInput.eofOnRead();
            }
            return buffer[0];
        }
        this.position = position + 1;
        return buffer[position];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readUnsignedByteDirect();
    }

    @Override
    public short readShort() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 2) {
            return (short)(this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect());
        }
        byte[] buffer = this.buffer;
        this.position = position + 2;
        return (short)(buffer[position] << 8 | buffer[position + 1] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 2) {
            return this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect();
        }
        byte[] buffer = this.buffer;
        this.position = position + 2;
        return (buffer[position] & 0xFF) << 8 | buffer[position + 1] & 0xFF;
    }

    protected int readUnsignedByteDirect() throws IOException {
        int position;
        int limit = this.limit;
        if (limit == -1) {
            throw SimpleDataInput.eofOnRead();
        }
        byte[] buffer = this.buffer;
        if ((position = this.position++) == limit) {
            this.position = 1;
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                throw SimpleDataInput.eofOnRead();
            }
            return buffer[0] & 0xFF;
        }
        return buffer[position] & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 2) {
            return (char)(this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect());
        }
        byte[] buffer = this.buffer;
        this.position = position + 2;
        return (char)(buffer[position] << 8 | buffer[position + 1] & 0xFF);
    }

    @Override
    public int readInt() throws IOException {
        return this.readIntDirect();
    }

    @Override
    public long readLong() throws IOException {
        return this.readLongDirect();
    }

    protected long readLongDirect() throws IOException {
        return (long)this.readIntDirect() << 32 | (long)this.readIntDirect() & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readIntDirect());
    }

    protected int readIntDirect() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 4) {
            return this.readUnsignedByteDirect() << 24 | this.readUnsignedByteDirect() << 16 | this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect();
        }
        byte[] buffer = this.buffer;
        this.position = position + 4;
        return buffer[position] << 24 | (buffer[position + 1] & 0xFF) << 16 | (buffer[position + 2] & 0xFF) << 8 | buffer[position + 3] & 0xFF;
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLongDirect());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() not supported");
    }

    @Override
    public String readUTF() throws IOException {
        return UTFUtils.readUTFBytesByByteCount(this, this.readUnsignedShort());
    }

    @Override
    public void close() throws IOException {
        ByteInput byteInput = this.byteInput;
        if (byteInput != null) {
            byteInput.close();
        }
    }

    protected void start(ByteInput byteInput) throws IOException {
        this.byteInput = byteInput;
        this.limit = 0;
        this.position = 0;
    }

    protected void finish() throws IOException {
        this.limit = -1;
        this.position = 0;
        this.byteInput = null;
    }
}

