/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModel;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeVisitor;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveModelNode;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNode;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    public static IArchiveFileSet[] getMatchingFilesets(IArchiveNode node, IPath path) {
        return ModelUtil.getMatchingFilesets(node, path, false);
    }

    public static IArchiveFileSet[] getMatchingFilesets(IArchiveNode node, final IPath path, final boolean inWorkspace) {
        final ArrayList rets = new ArrayList();
        IArchiveNodeVisitor visitor = new IArchiveNodeVisitor(){

            public boolean visit(IArchiveNode node) {
                if (node.getNodeType() == 2 && ((IArchiveFileSet)node).matchesPath(path, inWorkspace)) {
                    rets.add((IArchiveFileSet)node);
                }
                return true;
            }
        };
        if (node == null) {
            ArchivesModel.instance().accept(visitor);
        } else {
            node.accept(visitor);
        }
        return rets.toArray(new IArchiveFileSet[rets.size()]);
    }

    public static IArchiveFileSet[] findAllDescendentFilesets(IArchiveNode node) {
        ArrayList<IArchiveNode> matches = ModelUtil.findAllDescendents(node, 2, true);
        return matches.toArray(new IArchiveFileSet[matches.size()]);
    }

    public static IArchiveFolder[] findAllDescendentFolders(IArchiveNode node) {
        ArrayList<IArchiveNode> matches = ModelUtil.findAllDescendents(node, 3, false);
        return matches.toArray(new IArchiveFolder[matches.size()]);
    }

    public static ArrayList<IArchiveNode> findAllDescendents(IArchiveNode node, final int type, final boolean includeSelf) {
        final ArrayList<IArchiveNode> matches = new ArrayList<IArchiveNode>();
        final IArchiveNode original = node;
        node.accept(new IArchiveNodeVisitor(){

            public boolean visit(IArchiveNode node) {
                if (node.getNodeType() == type && !matches.contains(node) && (includeSelf || node != original)) {
                    matches.add(node);
                }
                return true;
            }
        });
        return matches;
    }

    public static boolean otherFilesetMatchesPathAndOutputLocation(IArchiveFileSet fileset, DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper file) {
        return ModelUtil.otherFilesetMatchesPathAndOutputLocation(fileset, (IPath)new Path(file.getAbsolutePath()), file.getFilesetRelative(), file.getRootArchiveRelative().toString(), null);
    }

    public static boolean otherFilesetMatchesPathAndOutputLocation(IArchiveFileSet fileset, IPath absolute, String fsRelative, String rootArchiveRelative, IArchiveNode root) {
        IArchiveFileSet[] filesets = ModelUtil.getMatchingFilesets(root, absolute);
        if (filesets.length == 0 || filesets.length == 1 && Arrays.asList(filesets).contains(fileset)) {
            return false;
        }
        boolean relativePathsMatch = false;
        boolean destinationsMatch = false;
        int i = 0;
        while (i < filesets.length) {
            if (!fileset.equals(filesets[i])) {
                DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] matches = filesets[i].getMatches(absolute);
                int j = 0;
                while (j < matches.length) {
                    relativePathsMatch |= matches[j].getRootArchiveRelative().toString().equals(rootArchiveRelative);
                    ++j;
                }
                destinationsMatch = fileset.getRootArchive().getArchiveFilePath().equals((Object)filesets[i].getRootArchive().getArchiveFilePath());
                if (relativePathsMatch && destinationsMatch) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static IPath getBaseDestinationFile(IArchiveNode node) {
        IArchiveNode[] nodes = ModelUtil.getReverseNodeTree(node);
        IPath lastConcrete = null;
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof IArchive) {
                lastConcrete = lastConcrete == null ? ((IArchive)nodes[i]).getArchiveFilePath() : lastConcrete.append(((IArchive)nodes[i]).getName());
                if (!((IArchive)nodes[i]).isExploded()) {
                    return lastConcrete;
                }
            } else if (nodes[i] instanceof IArchiveFolder) {
                lastConcrete = lastConcrete.append(((IArchiveFolder)nodes[i]).getName());
            }
            ++i;
        }
        return lastConcrete;
    }

    public static IPath getBaseDestinationFile(IArchiveFileSet node, IPath fsRelative) {
        IPath last = ModelUtil.getBaseDestinationFile(node);
        if (fsRelative != null) {
            IArchiveNode[] nodes = ModelUtil.getReverseNodeTree(node);
            boolean anyZipped = false;
            int i = 0;
            while (!anyZipped && i < nodes.length) {
                if (nodes[i] instanceof IArchive && !((IArchive)nodes[i]).isExploded()) {
                    anyZipped = true;
                }
                ++i;
            }
            if (!anyZipped) {
                last = last.append(fsRelative);
            }
        }
        return last;
    }

    private static IArchiveNode[] getReverseNodeTree(IArchiveNode node) {
        ArrayList<IArchiveNode> list = new ArrayList<IArchiveNode>();
        while (node != null && !(node instanceof ArchiveModelNode)) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        IArchiveNode[] nodes = list.toArray(new IArchiveNode[list.size()]);
        return nodes;
    }

    public static void fillArchiveModel(XbPackages node, IArchiveModelRootNode modelNode) throws ArchivesModelException {
        for (XbPackageNode child : node.getAllChildren()) {
            ArchiveNodeImpl childImpl = (ArchiveNodeImpl)ModelUtil.createPackageNodeImpl(child, modelNode);
            if (modelNode == null || childImpl == null) continue;
            try {
                if (modelNode instanceof ArchiveNodeImpl) {
                    ((ArchiveNodeImpl)((Object)modelNode)).addChild(childImpl, false);
                    continue;
                }
                modelNode.addChild(childImpl);
            }
            catch (ArchivesModelException ame) {
                ArchivesCore.getInstance().getLogger().log(4, ame.getMessage(), ame);
            }
        }
    }

    protected static IArchiveNode createPackageNodeImpl(XbPackageNode node, IArchiveNode parent) throws ArchivesModelException {
        IArchiveNode nodeImpl = ArchivesCore.getInstance().getNodeFactory().createNode(node);
        if (nodeImpl != null) {
            for (XbPackageNode child : node.getAllChildren()) {
                ArchiveNodeImpl childImpl = (ArchiveNodeImpl)ModelUtil.createPackageNodeImpl(child, nodeImpl);
                if (childImpl == null) continue;
                if (nodeImpl instanceof ArchiveNodeImpl) {
                    ((ArchiveNodeImpl)nodeImpl).addChild(childImpl, false);
                    continue;
                }
                nodeImpl.addChild(childImpl);
            }
        } else {
            Status status = new Status(2, "org.jboss.ide.eclipse.archives.core", NLS.bind((String)ArchivesCoreMessages.UnsupportedNodeType, (Object)node.getNodeType()));
            ArchivesCore.log((IStatus)status);
        }
        return nodeImpl;
    }

    public static IArchive[] getProjectArchives(IPath project) {
        return ModelUtil.getProjectArchives(project, ArchivesModel.instance());
    }

    public static IArchive[] getProjectArchives(IPath project, IArchiveModel model) {
        if (model != null) {
            IArchiveModelRootNode root = model.getRoot(project);
            if (root == null) {
                return new IArchive[0];
            }
            IArchiveNode[] archives = model.getRoot(project).getAllChildren();
            List<IArchiveNode> list = Arrays.asList(archives);
            return list.toArray(new IArchive[list.size()]);
        }
        return null;
    }
}

