/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal.xb;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNode;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbProperty;

public class XbProperties
extends XbPackageNode {
    private PropertiesExt properties = new PropertiesExt();

    public XbProperties() {
        super("properties");
    }

    public XbProperties(XbProperties props) {
        super(props);
        for (XbProperty element : this.getChildren(XbProperty.class)) {
            this.addProperty(element);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new XbProperties(this);
    }

    public PropertiesExt getProperties() {
        return this.properties;
    }

    public void addProperty(Object property) {
        this.addProperty((XbProperty)property);
    }

    public void addProperty(XbProperty property) {
        this.properties.setProperty(property.getName(), property.getValue());
        this.addChild(property);
    }

    public class PropertiesExt
    extends Properties {
        private static final long serialVersionUID = 1L;
        private Hashtable propertyElements = new Hashtable();

        public synchronized Object put(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException(ArchivesCore.bind(ArchivesCoreMessages.KeyIsNull, this.getClass().getName()));
            }
            if (value == null) {
                throw new NullPointerException(ArchivesCore.bind(ArchivesCoreMessages.ValueIsNull, this.getClass().getName()));
            }
            if (!this.propertyElements.containsKey(key)) {
                XbProperty element = new XbProperty();
                element.setName((String)key);
                element.setValue((String)value);
                this.propertyElements.put(key, element);
            } else {
                XbProperty element = (XbProperty)this.propertyElements.get(key);
                element.setValue((String)value);
            }
            return super.put(key, value);
        }

        public synchronized Object remove(Object key) {
            this.propertyElements.remove(key);
            return super.remove(key);
        }

        public Collection getPropertyElements() {
            return this.propertyElements.values();
        }
    }
}

