/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal.xb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.ArchivesUnmarshallerImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackages;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;

public class XMLBinding {
    public static final int NUM_UNMARSHAL_MONITOR_STEPS = 3;
    public static final int NUM_MARSHALL_MONITOR_STEPS = 2;
    private static URL schema = XMLBinding.class.getClassLoader().getResource("packages.xsd");
    private static URL log4jxml = XMLBinding.class.getClassLoader().getResource("log4j.xml");
    private static SchemaBinding binding;
    private static boolean initialized;

    static {
        initialized = false;
        System.setProperty("log4j.configuration", log4jxml.toString());
    }

    public static void init() {
        try {
            InputStream stream = schema.openStream();
            binding = XsdBinder.bind((InputStream)stream, (String)"UTF-8", null);
            stream.close();
            initialized = true;
        }
        catch (IOException e) {
            ArchivesCore.getInstance().getLogger().log(4, e.getMessage(), e);
        }
    }

    private static void binderSandbox(XbRunnable runnable) throws XbException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        ClassLoader myCL = XMLBinding.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(myCL);
        XbException e = null;
        try {
            runnable.run();
        }
        catch (XbException ex) {
            e = ex;
        }
        Thread.currentThread().setContextClassLoader(original);
        if (e != null) {
            throw e;
        }
    }

    public static XbPackages unmarshal(String input, IProgressMonitor monitor) throws XbException {
        return XMLBinding.unmarshal(new ByteArrayInputStream(input.getBytes()), monitor);
    }

    public static XbPackages unmarshal(File file, IProgressMonitor monitor) throws XbException {
        try {
            FileInputStream fis = new FileInputStream(file);
            return XMLBinding.unmarshal(fis, monitor);
        }
        catch (FileNotFoundException fnfe) {
            throw new XbException(fnfe);
        }
        catch (XbException xbe) {
            throw xbe;
        }
    }

    protected static XbPackages unmarshal(final InputStream in, final IProgressMonitor monitor) throws XbException {
        if (!initialized) {
            XMLBinding.init();
        }
        final XbPackages[] element = new XbPackages[]{null};
        XbRunnable runnable = new XbRunnable(){

            public void run() throws XbException {
                try {
                    ArchivesUnmarshallerImpl unmarshaller = new ArchivesUnmarshallerImpl();
                    monitor.worked(1);
                    binding.setStrictSchema(true);
                    unmarshaller.setValidation(true);
                    unmarshaller.getParser().setFeature("http://apache.org/xml/features/validation/schema", true);
                    unmarshaller.getParser().setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)schema.toExternalForm());
                    Object xmlObject = unmarshaller.unmarshal(in, binding);
                    monitor.worked(1);
                    element[0] = (XbPackages)xmlObject;
                    monitor.worked(1);
                }
                catch (JBossXBException e) {
                    throw new XbException((Exception)((Object)e));
                }
            }
        };
        XMLBinding.binderSandbox(runnable);
        return element[0];
    }

    public static String marshall(IArchive topLevelArchive, IProgressMonitor monitor) throws XbException {
        if (topLevelArchive.isTopLevel() && topLevelArchive instanceof ArchiveImpl) {
            XbPackages packs = (XbPackages)((ArchiveImpl)topLevelArchive).getNodeDelegate().getParent();
            StringWriter sw = new StringWriter();
            XMLBinding.marshall(packs, sw, monitor);
            return sw.toString();
        }
        return null;
    }

    public static void marshallToFile(XbPackages element, IPath filePath, IProgressMonitor monitor) throws XbException {
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(new FileOutputStream(filePath.toFile()));
                XMLBinding.marshall(element, writer, monitor);
            }
            catch (XbException xbe) {
                throw xbe;
            }
            catch (IOException ioe) {
                throw new XbException(ioe);
            }
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void marshall(final XbPackages element, final Writer writer, final IProgressMonitor monitor) throws XbException {
        if (!initialized) {
            XMLBinding.init();
        }
        XMLBinding.binderSandbox(new XbRunnable(){

            /*
             * Exception decompiling
             */
            public void run() throws XbException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public static String serializePackages(XbPackages packages, IProgressMonitor monitor) throws XbException {
        try {
            StringWriter sw = new StringWriter();
            XMLBinding.marshall(packages, sw, monitor);
            return new String(sw.toString());
        }
        catch (Exception e) {
            throw new XbException(e);
        }
    }

    public static class XbException
    extends Exception {
        private Exception parent;

        public XbException(Exception e) {
            this.parent = e;
        }

        public Exception getException() {
            return this.parent;
        }

        public String getMessage() {
            return this.parent.getCause() == null ? this.parent.getMessage() : this.parent.getCause().getMessage();
        }

        public Throwable getCause() {
            return this.parent;
        }
    }

    public static interface XbRunnable {
        public void run() throws XbException;
    }
}

