/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.ant;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ant.AntArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchivesVFS;
import org.jboss.ide.eclipse.archives.core.model.IVariableManager;
import org.jboss.ide.eclipse.archives.core.xpl.StringSubstitutionEngineClone;

public class AntVFS
implements IArchivesVFS,
IVariableManager {
    public static final String SUFFIX = ".dir";
    private String currentProject;

    public String performStringSubstitution(String expression, boolean reportUndefinedVariables) throws CoreException {
        return new StringSubstitutionEngineClone().performStringSubstitution(expression, reportUndefinedVariables, this);
    }

    public synchronized String performStringSubstitution(String expression, String projectName, boolean reportUndefinedVariables) throws CoreException {
        this.currentProject = projectName;
        String result = new StringSubstitutionEngineClone().performStringSubstitution(expression, reportUndefinedVariables, this);
        this.currentProject = null;
        return result;
    }

    public boolean containsVariable(String variable) {
        if ("archives_current_project".equals(variable)) {
            return true;
        }
        return ((AntArchivesCore)ArchivesCore.getInstance()).getProject().getProperty(variable) != null;
    }

    public String getVariableValue(String variable) {
        if ("archives_current_project".equals(variable)) {
            return this.currentProject;
        }
        return ((AntArchivesCore)ArchivesCore.getInstance()).getProject().getProperty(variable);
    }

    public IPath[] getWorkspaceChildren(IPath path) {
        ArrayList<IPath> list = new ArrayList<IPath>();
        IPath pathAbsolute = this.workspacePathToAbsolutePath(path);
        if (pathAbsolute != null && pathAbsolute.toFile().exists()) {
            String[] children = pathAbsolute.toFile().list();
            int i = 0;
            while (i < children.length) {
                IPath tmp = path.append(children[i]);
                list.add(tmp);
                ++i;
            }
        }
        return list.toArray(new IPath[list.size()]);
    }

    public IPath workspacePathToAbsolutePath(IPath path) {
        if (path.segmentCount() > 0 && path.segment(0) != null) {
            String projNameProperty = String.valueOf(path.segment(0)) + SUFFIX;
            Object result = ((AntArchivesCore)ArchivesCore.getInstance()).getProject().getProperties().get(projNameProperty);
            if (result != null && result instanceof String) {
                return new Path((String)result).append(path.removeFirstSegments(1));
            }
        }
        return null;
    }

    public String getProjectName(IPath absolutePath) {
        for (String property : ((AntArchivesCore)ArchivesCore.getInstance()).getProject().getProperties().keySet()) {
            String val;
            if (!property.endsWith(SUFFIX) || (val = ((AntArchivesCore)ArchivesCore.getInstance()).getProject().getProperty(property)) == null || !new Path(val).equals((Object)absolutePath)) continue;
            return property.substring(0, property.lastIndexOf(46));
        }
        return null;
    }

    public IPath[] absolutePathToWorkspacePath(IPath path) {
        return new IPath[0];
    }
}

