/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbds.product.intro.action;

import com.jboss.jbds.product.Activator;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class RunWizardIntroURLAction
implements IIntroAction {
    private static final int WIZARD_WIDTH = 500;
    private static final int WIZARD_HEIGHT = 500;

    public void run(IIntroSite site, Properties params) {
        if (params == null) {
            return;
        }
        String wizardPluginId = params.getProperty("wizardPluginId", null);
        String wizardId = params.getProperty("wizardId", null);
        if (wizardPluginId == null || wizardId == null) {
            return;
        }
        INewWizard wizard = this.findNewWizardsItem(wizardPluginId, wizardId);
        if (wizard == null) {
            return;
        }
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.ide.new_project_wizard_context");
        dialog.open();
    }

    private INewWizard findNewWizardsItem(String pluginId, String wizardId) {
        Platform.getBundle((String)pluginId);
        try {
            return (INewWizard)this.findClassByElementId("org.eclipse.ui.newWizards", wizardId);
        }
        catch (Exception ex) {
            Activator.logError("com.jboss.jbds.product", ex);
            return null;
        }
    }

    private Object findClassByElementId(String pointId, String id) throws Exception {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pointId);
        IConfigurationElement element = this.getElementById(point, id);
        if (element == null) {
            throw new RuntimeException("Configuration element with id=" + id + " is not found");
        }
        String className = element.getAttribute("class");
        if (className == null || className.length() == 0) {
            throw new RuntimeException("Configuration element with id=" + id + " does not define 'class' attribute");
        }
        return element.createExecutableExtension("class");
    }

    private IConfigurationElement getElementById(IExtensionPoint point, String id) {
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = this.getElementById(extensions[i].getConfigurationElements(), id);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private IConfigurationElement getElementById(IConfigurationElement[] elements, String id) {
        int i = 0;
        while (i < elements.length) {
            if (id.equals(elements[i].getAttribute("id"))) {
                return elements[i];
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            IConfigurationElement element = this.getElementById(elements[i].getChildren(), id);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }
}

