/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MergeMap<K, V> {
    final Map<K, V> map;

    protected abstract V mergeValues(V var1, V var2);

    public MergeMap() {
        this.map = new HashMap();
    }

    public MergeMap(Map<K, V> map) {
        this.map = map;
    }

    public V put(K k, V v) {
        V currentValue = this.map.get(k);
        if (currentValue == null) {
            this.map.put(k, v);
            return v;
        }
        V result = this.mergeValues(currentValue, v);
        if (currentValue != result) {
            this.map.put(k, v);
        }
        return result;
    }

    public V get(K k) {
        return this.map.get(k);
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public static void main(String[] args) {
        MaxMap<String, Integer> m = new MaxMap<String, Integer>();
        m.put("a", 1);
        m.put("a", 2);
        m.put("b", 2);
        m.put("b", 1);
        System.out.println(m.entrySet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MaxMap<K, V extends Comparable<? super V>>
    extends MergeMap<K, V> {
        @Override
        protected V mergeValues(V oldValue, V newValue) {
            if (oldValue.compareTo(newValue) < 0) {
                return newValue;
            }
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MinMap<K, V extends Comparable<? super V>>
    extends MergeMap<K, V> {
        @Override
        protected V mergeValues(V oldValue, V newValue) {
            if (oldValue.compareTo(newValue) > 0) {
                return newValue;
            }
            return oldValue;
        }
    }
}

