/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.graph.DepthFirstSearch;
import edu.umd.cs.findbugs.graph.Graph;
import edu.umd.cs.findbugs.graph.GraphEdge;
import edu.umd.cs.findbugs.graph.GraphToolkit;
import edu.umd.cs.findbugs.graph.GraphVertex;
import edu.umd.cs.findbugs.graph.SearchTree;
import edu.umd.cs.findbugs.graph.SearchTreeBuilder;
import edu.umd.cs.findbugs.graph.Transpose;
import edu.umd.cs.findbugs.graph.VertexChooser;
import edu.umd.cs.findbugs.graph.VisitationTimeComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StronglyConnectedComponents<GraphType extends Graph<EdgeType, VertexType>, EdgeType extends GraphEdge<EdgeType, VertexType>, VertexType extends GraphVertex<VertexType>> {
    private ArrayList<SearchTree<VertexType>> m_stronglyConnectedSearchTreeList = new ArrayList();
    private VertexChooser<VertexType> m_vertexChooser = null;

    public void setVertexChooser(VertexChooser<VertexType> vertexChooser) {
        this.m_vertexChooser = vertexChooser;
    }

    public void findStronglyConnectedComponents(GraphType g, GraphToolkit<GraphType, EdgeType, VertexType> toolkit) {
        DepthFirstSearch initialDFS = new DepthFirstSearch(g);
        if (this.m_vertexChooser != null) {
            initialDFS.setVertexChooser(this.m_vertexChooser);
        }
        initialDFS.search();
        Transpose<GraphType, EdgeType, VertexType> t = new Transpose<GraphType, EdgeType, VertexType>();
        Object transpose = t.transpose(g, toolkit);
        VisitationTimeComparator comparator = new VisitationTimeComparator(initialDFS.getFinishTimeList(), 1);
        TreeSet descendingByFinishTimeSet = new TreeSet(comparator);
        Iterator i = transpose.vertexIterator();
        while (i.hasNext()) {
            descendingByFinishTimeSet.add(i.next());
        }
        SearchTreeBuilder searchTreeBuilder = new SearchTreeBuilder();
        final Iterator vertexIter = descendingByFinishTimeSet.iterator();
        DepthFirstSearch transposeDFS = new DepthFirstSearch<GraphType, EdgeType, VertexType>((Graph)transpose){

            @Override
            protected VertexType getNextSearchTreeRoot() {
                while (vertexIter.hasNext()) {
                    GraphVertex vertex = (GraphVertex)vertexIter.next();
                    if (!this.visitMe(vertex)) continue;
                    return vertex;
                }
                return null;
            }
        };
        if (this.m_vertexChooser != null) {
            transposeDFS.setVertexChooser(this.m_vertexChooser);
        }
        transposeDFS.setSearchTreeCallback(searchTreeBuilder);
        transposeDFS.search();
        Iterator j = searchTreeBuilder.searchTreeIterator();
        while (j.hasNext()) {
            this.m_stronglyConnectedSearchTreeList.add(this.copySearchTree(j.next(), t));
        }
    }

    private SearchTree<VertexType> copySearchTree(SearchTree<VertexType> tree, Transpose<GraphType, EdgeType, VertexType> t) {
        SearchTree<VertexType> copy = new SearchTree<VertexType>(t.getOriginalGraphVertex(tree.getVertex()));
        Iterator<SearchTree<VertexType>> i = tree.childIterator();
        while (i.hasNext()) {
            SearchTree<VertexType> child = i.next();
            copy.addChild(this.copySearchTree(child, t));
        }
        return copy;
    }

    public Iterator<SearchTree<VertexType>> searchTreeIterator() {
        return this.m_stronglyConnectedSearchTreeList.iterator();
    }

    public Iterator<Set<VertexType>> setIterator() {
        return new SCCSetIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SCCSetIterator
    implements Iterator<Set<VertexType>> {
        private Iterator<SearchTree<VertexType>> m_searchTreeIterator;

        public SCCSetIterator() {
            this.m_searchTreeIterator = StronglyConnectedComponents.this.searchTreeIterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_searchTreeIterator.hasNext();
        }

        @Override
        public Set<VertexType> next() {
            SearchTree tree = this.m_searchTreeIterator.next();
            TreeSet set = new TreeSet();
            tree.addVerticesToSet(set);
            return set;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

