/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindUnsyncGet
extends BytecodeScanningDetector {
    String prevClassName = " none ";
    private BugReporter bugReporter;
    static final int doNotConsider = 266;
    private HashMap<String, MethodAnnotation> getMethods = new HashMap();
    private HashMap<String, MethodAnnotation> setMethods = new HashMap();

    public FindUnsyncGet(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void report() {
        HashSet<String> commonProperties = new HashSet<String>(this.getMethods.keySet());
        commonProperties.retainAll(this.setMethods.keySet());
        for (String propName : commonProperties) {
            MethodAnnotation getMethod = this.getMethods.get(propName);
            MethodAnnotation setMethod = this.setMethods.get(propName);
            this.bugReporter.reportBug(new BugInstance(this, "UG_SYNC_SET_UNSYNC_GET", 2).addClass(this.prevClassName).addMethod(getMethod).addMethod(setMethod));
        }
        this.getMethods.clear();
        this.setMethods.clear();
    }

    public void visit(JavaClass obj) {
        this.report();
        this.prevClassName = this.getDottedClassName();
    }

    public void visit(Method obj) {
        boolean isSynchronized;
        int flags = obj.getAccessFlags();
        if ((flags & 0x10A) != 0) {
            return;
        }
        String name = obj.getName();
        boolean bl = isSynchronized = (flags & 0x20) != 0;
        if (name.startsWith("get") && !isSynchronized) {
            this.getMethods.put(name.substring(3), MethodAnnotation.fromVisitedMethod(this));
        } else if (name.startsWith("set") && isSynchronized) {
            this.setMethods.put(name.substring(3), MethodAnnotation.fromVisitedMethod(this));
        }
    }
}

