/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassSummary;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.Code;

public class EqualsOperandShouldHaveClassCompatibleWithThis
extends OpcodeStackDetector
implements FirstPassDetector {
    final BugReporter bugReporter;
    final BugAccumulator bugAccumulator;
    final ClassSummary classSummary = new ClassSummary();

    public EqualsOperandShouldHaveClassCompatibleWithThis(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        context.setClassSummary(this.classSummary);
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals("equals") && this.getMethodSig().equals("(Ljava/lang/Object;)Z")) {
            super.visit(obj);
            if (AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass())) {
                this.bugAccumulator.reportAccumulatedBugs();
            }
            this.bugAccumulator.clearBugs();
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 182) {
            Object value;
            OpcodeStack.Item item;
            if (this.getNameConstantOperand().equals("equals") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z")) {
                OpcodeStack.Item item2 = this.stack.getStackItem(1);
                ClassDescriptor c = DescriptorFactory.createClassDescriptorFromSignature(item2.getSignature());
                this.check(c);
            } else if (this.getClassConstantOperand().equals("java/lang/Class") && (this.getNameConstantOperand().equals("isInstance") || this.getNameConstantOperand().equals("cast")) && (item = this.stack.getStackItem(1)).getSignature().equals("Ljava/lang/Class;") && (value = item.getConstant()) instanceof String) {
                ClassDescriptor c = DescriptorFactory.createClassDescriptor((String)value);
                this.check(c);
            }
        } else if (seen == 193 || seen == 192) {
            this.check(this.getClassDescriptorOperand());
        }
    }

    private void check(ClassDescriptor c) {
        OpcodeStack.Item item = this.stack.getStackItem(0);
        if (item.isInitialParameter() && item.getRegisterNumber() == 1) {
            ClassDescriptor thisClassDescriptor = this.getClassDescriptor();
            if (c.equals(thisClassDescriptor)) {
                return;
            }
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            try {
                if (subtypes2.isSubtype(c, thisClassDescriptor)) {
                    return;
                }
                if (subtypes2.isSubtype(thisClassDescriptor, c)) {
                    return;
                }
                IncompatibleTypes check = IncompatibleTypes.getPriorityForAssumingCompatible(false, thisClassDescriptor, c);
                int priority = check.getPriority();
                if ("java/lang/Object".equals(this.getSuperclassName()) && ClassName.isAnonymous(this.getClassName())) {
                    ++priority;
                }
                this.bugAccumulator.accumulateBug(new BugInstance(this, "EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS", priority).addClassAndMethod(this).addType(c).describe("TYPE_FOUND"), this);
                this.classSummary.checksForEqualTo(thisClassDescriptor, c);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("error", e);
            }
        }
    }
}

