/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.InterproceduralCallGraph;
import edu.umd.cs.findbugs.ba.ch.InterproceduralCallGraphVertex;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import org.apache.bcel.classfile.Method;

public class BuildInterproceduralCallGraph
extends BytecodeScanningDetector
implements NonReportingDetector {
    private final InterproceduralCallGraph callGraph = new InterproceduralCallGraph();
    private InterproceduralCallGraphVertex currentVertex;

    public BuildInterproceduralCallGraph(BugReporter bugReporter) {
    }

    public void visitClassContext(ClassContext classContext) {
        super.visitClassContext(classContext);
    }

    public void visitMethod(Method obj) {
        this.currentVertex = this.findVertex(this.getXMethod());
        super.visitMethod(obj);
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodDescriptor called = this.getMethodDescriptorOperand();
                XMethod calledXMethod = XFactory.createXMethod(called);
                InterproceduralCallGraphVertex calledVertex = this.findVertex(calledXMethod);
                this.callGraph.createEdge(this.currentVertex, calledVertex);
            }
        }
    }

    private InterproceduralCallGraphVertex findVertex(XMethod xmethod) {
        InterproceduralCallGraphVertex vertex = this.callGraph.lookupVertex(xmethod.getMethodDescriptor());
        if (vertex == null) {
            vertex = new InterproceduralCallGraphVertex();
            vertex.setXmethod(xmethod);
            this.callGraph.addVertex(vertex);
        }
        return vertex;
    }

    public void report() {
        Global.getAnalysisCache().eagerlyPutDatabase(InterproceduralCallGraph.class, this.callGraph);
    }
}

