/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.AbstractDataflow;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNumberDataflow
extends AbstractDataflow<ValueNumberFrame, ValueNumberAnalysis> {
    public ValueNumberDataflow(CFG cfg, ValueNumberAnalysis analysis) {
        super(cfg, analysis);
    }

    public Map<ValueNumber, Integer> getValueNumberToParamMap(Method method) {
        return this.getValueNumberToParamMap(method.getSignature(), method.isStatic());
    }

    public Map<ValueNumber, Integer> getValueNumberToParamMap(String methodSignature, boolean isStatic) {
        HashMap<ValueNumber, Integer> valueNumberToParamMap = new HashMap<ValueNumber, Integer>();
        ValueNumberFrame frameAtEntry = (ValueNumberFrame)this.getStartFact(this.getCFG().getEntry());
        int numParams = new SignatureParser(methodSignature).getNumParameters();
        int shift = isStatic ? 0 : 1;
        for (int i = 0; i < numParams; ++i) {
            valueNumberToParamMap.put((ValueNumber)frameAtEntry.getValue(i + shift), i);
        }
        return valueNumberToParamMap;
    }

    @CheckForNull
    @DottedClassName
    public String getClassName(ValueNumber v) {
        return ((ValueNumberAnalysis)this.getAnalysis()).getClassName(v);
    }
}

