/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.DefaultNullnessAnnotations;
import edu.umd.cs.findbugs.ba.INullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.jsr305.FindBugsDefaultAnnotations;
import edu.umd.cs.findbugs.ba.jsr305.JSR305NullnessAnnotations;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.analysis.FieldInfo;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.log.Profiler;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.meta.When;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

public class TypeQualifierNullnessAnnotationDatabase
implements INullnessAnnotationDatabase {
    private static final boolean DEBUG = SystemProperties.getBoolean("findbugs.npe.tq.debug");
    public final TypeQualifierValue nonnullTypeQualifierValue;
    private static final ClassDescriptor PARAMETERS_ARE_NONNULL_BY_DEFAULT = DescriptorFactory.createClassDescriptor(ParametersAreNonnullByDefault.class);
    private static final ClassDescriptor RETURN_VALUES_ARE_NONNULL_BY_DEFAULT = DescriptorFactory.createClassDescriptor(ReturnValuesAreNonnullByDefault.class);

    public TypeQualifierNullnessAnnotationDatabase() {
        ClassDescriptor nonnullClassDesc = DescriptorFactory.createClassDescriptor(Nonnull.class);
        this.nonnullTypeQualifierValue = TypeQualifierValue.getValue(nonnullClassDesc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NullnessAnnotation getResolvedAnnotation(Object o, boolean getMinimal) {
        Profiler profiler = Global.getAnalysisCache().getProfiler();
        profiler.start(this.getClass());
        try {
            if (DEBUG) {
                System.out.println("getResolvedAnnotation: o=" + o + "...");
            }
            TypeQualifierAnnotation tqa = null;
            if (o instanceof XMethodParameter) {
                XMethodParameter param = (XMethodParameter)o;
                tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(param.getMethod(), param.getParameterNumber(), this.nonnullTypeQualifierValue);
            } else if (o instanceof XMethod || o instanceof XField) {
                tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation((AnnotatedObject)o, this.nonnullTypeQualifierValue);
            }
            NullnessAnnotation result = this.toNullnessAnnotation(tqa);
            if (DEBUG) {
                System.out.println("   ==> " + (result != null ? result.toString() : "not found"));
            }
            NullnessAnnotation nullnessAnnotation = result;
            return nullnessAnnotation;
        }
        finally {
            profiler.end(this.getClass());
        }
    }

    public boolean parameterMustBeNonNull(XMethod m, int param) {
        boolean answer;
        TypeQualifierAnnotation tqa;
        if (DEBUG) {
            System.out.print("Checking " + m + " param " + param + " for @Nonnull...");
        }
        if ((tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(m, param, this.nonnullTypeQualifierValue)) == null && param == 0) {
            String name = m.getName();
            String signature = m.getSignature();
            if (name.equals("main") && signature.equals("([Ljava/lang/String;)V") && m.isStatic() && m.isPublic()) {
                return true;
            }
            if (NullnessAnnotationDatabase.assertsFirstParameterIsNonnull(m)) {
                return true;
            }
            if (name.equals("compareTo") && signature.substring(signature.indexOf(";") + 1).equals(")Z") && !m.isStatic()) {
                return true;
            }
        }
        boolean bl = answer = tqa != null && tqa.when == When.ALWAYS;
        if (DEBUG) {
            System.out.println(answer ? "yes" : "no");
        }
        return answer;
    }

    private ClassDescriptor getNullnessAnnotationClassDescriptor(NullnessAnnotation n) {
        if (n == NullnessAnnotation.CHECK_FOR_NULL) {
            return JSR305NullnessAnnotations.CHECK_FOR_NULL;
        }
        if (n == NullnessAnnotation.NONNULL) {
            return JSR305NullnessAnnotations.NONNULL;
        }
        if (n == NullnessAnnotation.NULLABLE) {
            return JSR305NullnessAnnotations.NULLABLE;
        }
        if (n == NullnessAnnotation.UNKNOWN_NULLNESS) {
            return JSR305NullnessAnnotations.NULLABLE;
        }
        throw new IllegalArgumentException("Unknown NullnessAnnotation: " + n);
    }

    public void addDefaultAnnotation(AnnotationDatabase.Target target, String c, NullnessAnnotation n) {
        ClassDescriptor defaultAnnotationType;
        ClassInfo xclass;
        if (DEBUG) {
            System.out.println("addDefaultAnnotation: target=" + (Object)((Object)target) + ", c=" + c + ", n=" + n);
        }
        ClassDescriptor classDesc = DescriptorFactory.instance().getClassDescriptorForDottedClassName(c);
        try {
            xclass = (ClassInfo)Global.getAnalysisCache().getClassAnalysis(XClass.class, classDesc);
        }
        catch (MissingClassException e) {
            return;
        }
        catch (CheckedAnalysisException e) {
            return;
        }
        if (n == NullnessAnnotation.NONNULL && target == AnnotationDatabase.Target.PARAMETER) {
            xclass.addAnnotation(new AnnotationValue(PARAMETERS_ARE_NONNULL_BY_DEFAULT));
            return;
        }
        if (n == NullnessAnnotation.NONNULL && target == AnnotationDatabase.Target.METHOD) {
            xclass.addAnnotation(new AnnotationValue(RETURN_VALUES_ARE_NONNULL_BY_DEFAULT));
            return;
        }
        if (target == AnnotationDatabase.Target.ANY) {
            defaultAnnotationType = FindBugsDefaultAnnotations.DEFAULT_ANNOTATION;
        } else if (target == AnnotationDatabase.Target.FIELD) {
            defaultAnnotationType = FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_FIELDS;
        } else if (target == AnnotationDatabase.Target.METHOD) {
            defaultAnnotationType = FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_METHODS;
        } else if (target == AnnotationDatabase.Target.PARAMETER) {
            defaultAnnotationType = FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_PARAMETERS;
        } else {
            throw new IllegalArgumentException("Unknown target for default annotation: " + (Object)((Object)target));
        }
        ClassDescriptor nullnessAnnotationType = this.getNullnessAnnotationClassDescriptor(n);
        AnnotationValue annotationValue = new AnnotationValue(defaultAnnotationType);
        AnnotationVisitor v = annotationValue.getAnnotationVisitor();
        v.visit("value", (Object)Type.getObjectType((String)nullnessAnnotationType.getClassName()));
        v.visitEnd();
        if (DEBUG) {
            System.out.println("Adding AnnotationValue " + annotationValue + " to class " + xclass);
        }
        xclass.addAnnotation(annotationValue);
    }

    public void addFieldAnnotation(String cName, String mName, String mSig, boolean isStatic, NullnessAnnotation annotation) {
        XField xfield;
        if (DEBUG) {
            System.out.println("addFieldAnnotation: annotate " + cName + "." + mName + " with " + annotation);
        }
        if (!((xfield = XFactory.createXField(cName, mName, mSig, isStatic)) instanceof FieldInfo)) {
            if (DEBUG) {
                System.out.println("  Field not found! " + cName + "." + mName + ":" + mSig + " " + isStatic + " " + annotation);
            }
            return;
        }
        ClassDescriptor nullnessAnnotationType = this.getNullnessAnnotationClassDescriptor(annotation);
        AnnotationValue annotationValue = new AnnotationValue(nullnessAnnotationType);
        ((FieldInfo)xfield).addAnnotation(annotationValue);
    }

    @CheckForNull
    public XMethod getXMethod(String cName, String mName, String sig, boolean isStatic) {
        ClassInfo xclass;
        ClassDescriptor classDesc = DescriptorFactory.instance().getClassDescriptorForDottedClassName(cName);
        try {
            xclass = (ClassInfo)Global.getAnalysisCache().getClassAnalysis(XClass.class, classDesc);
        }
        catch (MissingClassException e) {
            if (DEBUG) {
                System.out.println("  Class not found!");
            }
            return null;
        }
        catch (CheckedAnalysisException e) {
            if (DEBUG) {
                System.out.println("  Class not found!");
            }
            return null;
        }
        XMethod xmethod = xclass.findMethod(mName, sig, isStatic);
        if (xmethod == null) {
            xmethod = XFactory.createXMethod(cName, mName, sig, isStatic);
        }
        if (xmethod == null || !xmethod.isResolved()) {
            if (DEBUG) {
                for (XMethod xMethod : xclass.getXMethods()) {
                    if (!xMethod.getName().equals(mName)) continue;
                    System.out.println(xMethod);
                }
                System.out.println("  Method not found!");
            }
            return null;
        }
        return xmethod;
    }

    public void addMethodAnnotation(String cName, String mName, String sig, boolean isStatic, NullnessAnnotation annotation) {
        XMethod xmethod;
        if (DEBUG) {
            System.out.println("addMethodAnnotation: annotate " + cName + "." + mName + " with " + annotation);
        }
        if ((xmethod = this.getXMethod(cName, mName, sig, isStatic)) == null) {
            return;
        }
        ClassDescriptor nullnessAnnotationType = this.getNullnessAnnotationClassDescriptor(annotation);
        AnnotationValue annotationValue = new AnnotationValue(nullnessAnnotationType);
        ((MethodInfo)xmethod).addAnnotation(annotationValue);
    }

    public void addMethodParameterAnnotation(@DottedClassName String cName, String mName, String sig, boolean isStatic, int param, NullnessAnnotation annotation) {
        XMethod xmethod;
        if (DEBUG) {
            System.out.println("addMethodParameterAnnotation: annotate " + cName + "." + mName + " param " + param + " with " + annotation);
        }
        if ((xmethod = this.getXMethod(cName, mName, sig, isStatic)) == null) {
            return;
        }
        if (!(xmethod instanceof MethodInfo)) {
            return;
        }
        if (!xmethod.getClassName().equals(cName)) {
            return;
        }
        ClassDescriptor nullnessAnnotationType = this.getNullnessAnnotationClassDescriptor(annotation);
        AnnotationValue annotationValue = new AnnotationValue(nullnessAnnotationType);
        ((MethodInfo)xmethod).addParameterAnnotation(param, annotationValue);
    }

    public void loadAuxiliaryAnnotations() {
        DefaultNullnessAnnotations.addDefaultNullnessAnnotations(this);
    }

    private NullnessAnnotation toNullnessAnnotation(@CheckForNull TypeQualifierAnnotation tqa) {
        if (tqa == null) {
            return null;
        }
        switch (tqa.when) {
            case ALWAYS: {
                return NullnessAnnotation.NONNULL;
            }
            case MAYBE: {
                return NullnessAnnotation.CHECK_FOR_NULL;
            }
            case NEVER: {
                return NullnessAnnotation.CHECK_FOR_NULL;
            }
            case UNKNOWN: {
                return NullnessAnnotation.UNKNOWN_NULLNESS;
            }
        }
        throw new IllegalStateException();
    }
}

