/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceValueFrameModelingVisitor
extends AbstractFrameModelingVisitor<ResourceValue, ResourceValueFrame> {
    public ResourceValueFrameModelingVisitor(ConstantPoolGen cpg) {
        super(cpg);
    }

    @Override
    public ResourceValue getDefaultValue() {
        return ResourceValue.notInstance();
    }

    public abstract void transferInstruction(InstructionHandle var1, BasicBlock var2) throws DataflowAnalysisException;

    private void handleFieldStore(FieldInstruction ins) {
        try {
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            ResourceValue topValue = (ResourceValue)frame.getTopValue();
            if (topValue.equals(ResourceValue.instance())) {
                frame.setStatus(0);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow", e);
        }
        this.handleNormalInstruction((Instruction)ins);
    }

    @Override
    public void visitPUTFIELD(PUTFIELD putfield) {
        this.handleFieldStore((FieldInstruction)putfield);
    }

    private void handleArrayStore(ArrayInstruction ins) {
        try {
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            ResourceValue topValue = (ResourceValue)frame.getTopValue();
            if (topValue.equals(ResourceValue.instance())) {
                frame.setStatus(0);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow", e);
        }
        this.handleNormalInstruction((Instruction)ins);
    }

    @Override
    public void visitAASTORE(AASTORE arr) {
        this.handleArrayStore((ArrayInstruction)arr);
    }

    @Override
    public void visitPUTSTATIC(PUTSTATIC putstatic) {
        this.handleFieldStore((FieldInstruction)putstatic);
    }

    protected boolean instanceEscapes(InvokeInstruction inv, int instanceArgNum) {
        return true;
    }

    private void handleInvoke(InvokeInstruction inv) {
        ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
        int numSlots = frame.getNumSlots();
        int numConsumed = this.getNumWordsConsumed((Instruction)inv);
        int instanceArgNum = -1;
        int i = numSlots - numConsumed;
        int argCount = 0;
        while (i < numSlots) {
            ResourceValue value = (ResourceValue)frame.getValue(i);
            if (value.equals(ResourceValue.instance())) {
                instanceArgNum = argCount;
                break;
            }
            ++i;
            ++argCount;
        }
        if (instanceArgNum >= 0 && this.instanceEscapes(inv, instanceArgNum)) {
            frame.setStatus(0);
        }
        this.handleNormalInstruction((Instruction)inv);
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
        try {
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            ResourceValue topValue = (ResourceValue)frame.getTopValue();
            if (topValue.equals(ResourceValue.instance())) {
                frame.setStatus(0);
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Analysis error", e);
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL inv) {
        this.handleInvoke((InvokeInstruction)inv);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE inv) {
        this.handleInvoke((InvokeInstruction)inv);
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL inv) {
        this.handleInvoke((InvokeInstruction)inv);
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC inv) {
        this.handleInvoke((InvokeInstruction)inv);
    }

    @Override
    public void visitARETURN(ARETURN ins) {
        try {
            ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
            ResourceValue topValue = (ResourceValue)frame.getTopValue();
            if (topValue.equals(ResourceValue.instance())) {
                frame.setStatus(0);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow", e);
        }
        this.handleNormalInstruction((Instruction)ins);
    }
}

