/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractClassMember;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import javax.annotation.CheckForNull;

public abstract class AbstractMethod
extends AbstractClassMember
implements XMethod {
    final String bridgeMethodSignature;

    protected AbstractMethod(@DottedClassName String className, String methodName, String methodSig, @CheckForNull String bridgeMethodSig, int accessFlags) {
        super(className, methodName, methodSig, accessFlags);
        this.bridgeMethodSignature = DescriptorFactory.canonicalizeString(bridgeMethodSig);
    }

    public int getNumParams() {
        return new SignatureParser(this.getSignature()).getNumParameters();
    }

    public boolean isNative() {
        return (this.getAccessFlags() & 0x100) != 0;
    }

    public boolean isSynchronized() {
        return (this.getAccessFlags() & 0x20) != 0;
    }

    public String toString() {
        return SignatureConverter.convertMethodSignature(this);
    }

    public MethodDescriptor getMethodDescriptor() {
        return DescriptorFactory.instance().getMethodDescriptor(ClassName.toSlashedClassName(this.getClassName()), this.getName(), this.getSignature(), this.isStatic());
    }

    public final boolean isBridged() {
        return this.bridgeMethodSignature != null;
    }

    public final String getBridgeSignature() {
        return this.bridgeMethodSignature;
    }
}

