/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.SAXBugCollectionHandler;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.URLClassPath;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutputUtil;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.dom4j.DocumentException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements XMLWriteable {
    private static final boolean DEBUG = SystemProperties.getBoolean("findbugs.project.debug");
    private List<File> currentWorkingDirectoryList;
    @Deprecated
    private String projectFileName = "<<unnamed project>>";
    private String projectName;
    @Deprecated
    private Map<String, Boolean> optionsMap;
    private List<String> analysisTargets;
    private List<String> srcDirList;
    private List<String> auxClasspathEntryList;
    private boolean isModified;
    public static final String UNNAMED_PROJECT = "<<unnamed project>>";
    private long timestampForAnalyzedClasses = 0L;
    private IGuiCallback guiCallback;
    @NonNull
    private Filter suppressionFilter = new Filter();
    private SourceFinder sourceFinder;
    private static final String OPTIONS_KEY = "[Options]";
    private static final String JAR_FILES_KEY = "[Jar files]";
    private static final String SRC_DIRS_KEY = "[Source dirs]";
    private static final String AUX_CLASSPATH_ENTRIES_KEY = "[Aux classpath entries]";
    public static final String RELATIVE_PATHS = "relative_paths";
    static final String JAR_ELEMENT_NAME = "Jar";
    static final String AUX_CLASSPATH_ENTRY_ELEMENT_NAME = "AuxClasspathEntry";
    static final String SRC_DIR_ELEMENT_NAME = "SrcDir";
    static final String WRK_DIR_ELEMENT_NAME = "WrkDir";
    static final String FILENAME_ATTRIBUTE_NAME = "filename";
    static final String PROJECTNAME_ATTRIBUTE_NAME = "projectName";
    private static final boolean FILE_IGNORE_CASE = SystemProperties.getProperty("os.name", "unknown").startsWith("Windows");

    public Project() {
        this.optionsMap = new HashMap<String, Boolean>();
        this.optionsMap.put(RELATIVE_PATHS, Boolean.FALSE);
        this.analysisTargets = new LinkedList<String>();
        this.srcDirList = new LinkedList<String>();
        this.auxClasspathEntryList = new LinkedList<String>();
        this.isModified = false;
        this.currentWorkingDirectoryList = new ArrayList<File>();
    }

    public Project duplicate() {
        Project dup = new Project();
        dup.projectFileName = this.projectFileName;
        dup.currentWorkingDirectoryList.addAll(this.currentWorkingDirectoryList);
        dup.projectName = this.projectName;
        dup.optionsMap.clear();
        dup.optionsMap.putAll(this.optionsMap);
        dup.analysisTargets.addAll(this.analysisTargets);
        dup.srcDirList.addAll(this.srcDirList);
        dup.auxClasspathEntryList.addAll(this.auxClasspathEntryList);
        dup.timestampForAnalyzedClasses = this.timestampForAnalyzedClasses;
        dup.guiCallback = this.guiCallback;
        return dup;
    }

    public SourceFinder getSourceFinder() {
        if (this.sourceFinder == null) {
            this.sourceFinder = new SourceFinder(this);
        }
        return this.sourceFinder;
    }

    public boolean isGuiAvaliable() {
        return this.guiCallback != null;
    }

    public void add(Project project2) {
        this.optionsMap.putAll(project2.optionsMap);
        this.analysisTargets = Project.appendWithoutDuplicates(this.analysisTargets, project2.analysisTargets);
        this.srcDirList = Project.appendWithoutDuplicates(this.srcDirList, project2.srcDirList);
        this.auxClasspathEntryList = Project.appendWithoutDuplicates(this.auxClasspathEntryList, project2.auxClasspathEntryList);
    }

    public static <T> List<T> appendWithoutDuplicates(List<T> lst1, List<T> lst2) {
        LinkedHashSet<T> joined = new LinkedHashSet<T>(lst1);
        joined.addAll(lst2);
        return new ArrayList<T>(joined);
    }

    public void setCurrentWorkingDirectory(File f) {
        if (f != null) {
            this.addWorkingDir(f.toString());
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        this.isModified = isModified;
    }

    @Deprecated
    public String getProjectFileName() {
        return this.projectFileName;
    }

    @Deprecated
    public void setProjectFileName(String projectFileName) {
        this.projectFileName = projectFileName;
    }

    public boolean addFile(String fileName) {
        return this.addToListInternal(this.analysisTargets, this.makeAbsoluteCWD(fileName));
    }

    public boolean addSourceDir(String dirName) {
        boolean isNew = false;
        for (String dir : this.makeAbsoluteCwdCandidates(dirName)) {
            isNew = this.addToListInternal(this.srcDirList, dir) || isNew;
        }
        return isNew;
    }

    public boolean addWorkingDir(String dirName) {
        if (dirName == null) {
            throw new NullPointerException();
        }
        return this.addToListInternal(this.currentWorkingDirectoryList, new File(dirName));
    }

    @Deprecated
    public boolean getOption(String option) {
        Boolean value = this.optionsMap.get(option);
        return value != null && value != false;
    }

    public int getFileCount() {
        return this.analysisTargets.size();
    }

    public String getFile(int num) {
        return this.analysisTargets.get(num);
    }

    public void removeFile(int num) {
        this.analysisTargets.remove(num);
        this.isModified = true;
    }

    public List<String> getFileList() {
        return this.analysisTargets;
    }

    public int getNumSourceDirs() {
        return this.srcDirList.size();
    }

    public String getSourceDir(int num) {
        return this.srcDirList.get(num);
    }

    public void removeSourceDir(int num) {
        this.srcDirList.remove(num);
        this.isModified = true;
    }

    public String[] getFileArray() {
        return this.analysisTargets.toArray(new String[this.analysisTargets.size()]);
    }

    public String[] getSourceDirArray() {
        return this.srcDirList.toArray(new String[this.srcDirList.size()]);
    }

    public List<String> getSourceDirList() {
        return this.srcDirList;
    }

    public boolean addAuxClasspathEntry(String auxClasspathEntry) {
        return this.addToListInternal(this.auxClasspathEntryList, this.makeAbsoluteCWD(auxClasspathEntry));
    }

    public int getNumAuxClasspathEntries() {
        return this.auxClasspathEntryList.size();
    }

    public String getAuxClasspathEntry(int n) {
        return this.auxClasspathEntryList.get(n);
    }

    public void removeAuxClasspathEntry(int n) {
        this.auxClasspathEntryList.remove(n);
        this.isModified = true;
    }

    public List<String> getAuxClasspathEntryList() {
        return this.auxClasspathEntryList;
    }

    @Deprecated
    public List<String> getImplicitClasspathEntryList() {
        LinkedList<String> implicitClasspath = new LinkedList<String>();
        WorkList workList = new WorkList();
        for (String fileName : this.analysisTargets) {
            try {
                URL url = workList.createURL(fileName);
                WorkListItem item = new WorkListItem(url);
                workList.add(item);
            }
            catch (MalformedURLException ignore) {}
        }
        while (!workList.isEmpty()) {
            WorkListItem item = workList.getNextItem();
            this.processComponentJar(item.getURL(), workList, implicitClasspath);
        }
        return implicitClasspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processComponentJar(URL jarFileURL, WorkList workList, List<String> implicitClasspath) {
        if (DEBUG) {
            System.out.println("Processing " + jarFileURL.toString());
        }
        if (!jarFileURL.toString().endsWith(".zip") && !jarFileURL.toString().endsWith(".jar")) {
            return;
        }
        try {
            URL manifestURL = new URL("jar:" + jarFileURL.toString() + "!/META-INF/MANIFEST.MF");
            InputStream in = null;
            try {
                in = manifestURL.openStream();
                Manifest manifest = new Manifest(in);
                Attributes mainAttrs = manifest.getMainAttributes();
                String classPath = mainAttrs.getValue("Class-Path");
                if (classPath != null) {
                    String[] fileList;
                    for (String jarFile : fileList = classPath.split("\\s+")) {
                        URL referencedURL = workList.createRelativeURL(jarFileURL, jarFile);
                        if (!workList.add(new WorkListItem(referencedURL))) continue;
                        implicitClasspath.add(referencedURL.toString());
                        if (!DEBUG) continue;
                        System.out.println("Implicit jar: " + referencedURL.toString());
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void write(String outputFile, boolean useRelativePaths, String relativeBase) throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        try {
            writer.println(JAR_FILES_KEY);
            for (String jarFile : this.analysisTargets) {
                if (useRelativePaths) {
                    jarFile = this.convertToRelative(jarFile, relativeBase);
                }
                writer.println(jarFile);
            }
            writer.println(SRC_DIRS_KEY);
            for (String srcDir : this.srcDirList) {
                if (useRelativePaths) {
                    srcDir = this.convertToRelative(srcDir, relativeBase);
                }
                writer.println(srcDir);
            }
            writer.println(AUX_CLASSPATH_ENTRIES_KEY);
            for (String auxClasspathEntry : this.auxClasspathEntryList) {
                if (useRelativePaths) {
                    auxClasspathEntry = this.convertToRelative(auxClasspathEntry, relativeBase);
                }
                writer.println(auxClasspathEntry);
            }
            if (useRelativePaths) {
                writer.println(OPTIONS_KEY);
                writer.println("relative_paths=true");
            }
        }
        finally {
            writer.close();
        }
        this.isModified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project readXML(File f) throws IOException, DocumentException, SAXException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        Project project = new Project();
        try {
            SAXBugCollectionHandler handler;
            String tag = Util.getXMLType(in);
            if (tag.equals("Project")) {
                handler = new SAXBugCollectionHandler(project, f);
            } else if (tag.equals("BugCollection")) {
                SortedBugCollection bugs = new SortedBugCollection(project);
                handler = new SAXBugCollectionHandler(bugs, f);
            } else {
                throw new IOException("Can't load a project from a " + tag + " file");
            }
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            Reader reader = Util.getReader(in);
            xr.parse(new InputSource(reader));
        }
        finally {
            ((InputStream)in).close();
        }
        project.setModified(false);
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXML(File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        OutputStreamXMLOutput xmlOutput = new OutputStreamXMLOutput(out);
        try {
            this.writeXML(xmlOutput);
        }
        finally {
            xmlOutput.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void read(String inputFile) throws IOException {
        if (this.isModified) {
            throw new IllegalStateException("Reading into a modified Project!");
        }
        File file = new File(inputFile);
        if (!file.isAbsolute()) {
            inputFile = file.getAbsolutePath();
        }
        this.setProjectFileName(inputFile);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(Util.getFileReader(inputFile));
            String line = Project.getLine(reader);
            if (line == null || !line.equals(JAR_FILES_KEY)) {
                throw new IOException("Bad format: missing jar files key");
            }
            while ((line = Project.getLine(reader)) != null && !line.equals(SRC_DIRS_KEY)) {
                this.addToListInternal(this.analysisTargets, line);
            }
            if (line == null) {
                throw new IOException("Bad format: missing source dirs key");
            }
            while ((line = Project.getLine(reader)) != null && !line.equals(AUX_CLASSPATH_ENTRIES_KEY)) {
                this.addToListInternal(this.srcDirList, line);
            }
            if (line != null) {
                while ((line = Project.getLine(reader)) != null && !line.equals(OPTIONS_KEY)) {
                    this.addToListInternal(this.auxClasspathEntryList, line);
                }
            }
            if (line != null && line.equals(OPTIONS_KEY)) {
                while ((line = Project.getLine(reader)) != null && !line.equals(JAR_FILES_KEY)) {
                    this.parseOption(line);
                }
            }
            if (this.getOption(RELATIVE_PATHS)) {
                this.makeListAbsoluteProject(this.analysisTargets);
                this.makeListAbsoluteProject(this.srcDirList);
                this.makeListAbsoluteProject(this.auxClasspathEntryList);
            }
            this.isModified = false;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static Project readProject(String argument) throws IOException {
        String projectFileName = argument;
        File projectFile = new File(projectFileName);
        if (projectFile.isDirectory()) {
            String name = projectFile.getAbsolutePath() + File.separator + projectFile.getName() + ".xml";
            File f = new File(name);
            SortedBugCollection bugCollection = new SortedBugCollection();
            try {
                bugCollection.readXML(f.getPath());
                return bugCollection.getProject();
            }
            catch (DocumentException e) {
                IOException ioe = new IOException("Couldn't read saved XML in project directory");
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (projectFileName.endsWith(".xml") || projectFileName.endsWith(".fbp")) {
            try {
                return Project.readXML(projectFile);
            }
            catch (DocumentException e) {
                IOException ioe = new IOException("Couldn't read saved FindBugs project");
                ioe.initCause(e);
                throw ioe;
            }
            catch (SAXException e) {
                IOException ioe = new IOException("Couldn't read saved FindBugs project");
                ioe.initCause(e);
                throw ioe;
            }
        }
        projectFileName = new File(projectFileName).getAbsolutePath();
        try {
            Project project = new Project();
            project.read(projectFileName);
            return project;
        }
        catch (IOException e) {
            System.err.println("Error opening " + projectFileName);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private static String getLine(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && ((line = line.trim()).equals("") || line.startsWith("#"))) {
        }
        return line;
    }

    public String projectNameFromProjectFileName() {
        int dot;
        String name = this.projectFileName;
        int lastSep = name.lastIndexOf(File.separatorChar);
        if (lastSep >= 0) {
            name = name.substring(lastSep + 1);
        }
        if ((dot = name.lastIndexOf(46)) >= 0) {
            name = name.substring(0, dot);
        }
        return name;
    }

    public String toString() {
        int dot;
        if (this.projectName != null) {
            return this.projectName;
        }
        String name = this.projectFileName;
        int lastSep = name.lastIndexOf(File.separatorChar);
        if (lastSep >= 0) {
            name = name.substring(lastSep + 1);
        }
        int n = dot = name.endsWith(".fb") ? name.length() - 3 : -1;
        if (dot >= 0) {
            name = name.substring(0, dot);
        }
        return name;
    }

    public static String transformFilename(String fileName) {
        if (!fileName.endsWith(".fb")) {
            fileName = fileName + ".fb";
        }
        return fileName;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, null);
    }

    public void writeXML(XMLOutput xmlOutput, @CheckForNull Object destination) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList();
        if (!this.getProjectFileName().equals(UNNAMED_PROJECT)) {
            attributeList.addAttribute(FILENAME_ATTRIBUTE_NAME, this.getProjectFileName());
        }
        if (this.getProjectName() != null) {
            attributeList = attributeList.addAttribute(PROJECTNAME_ATTRIBUTE_NAME, this.getProjectName());
        }
        xmlOutput.openTag("Project", attributeList);
        XMLOutputUtil.writeElementList(xmlOutput, JAR_ELEMENT_NAME, this.analysisTargets);
        XMLOutputUtil.writeElementList(xmlOutput, AUX_CLASSPATH_ENTRY_ELEMENT_NAME, this.auxClasspathEntryList);
        XMLOutputUtil.writeElementList(xmlOutput, SRC_DIR_ELEMENT_NAME, this.srcDirList);
        XMLOutputUtil.writeFileList(xmlOutput, WRK_DIR_ELEMENT_NAME, this.currentWorkingDirectoryList);
        if (this.suppressionFilter != null && !this.suppressionFilter.isEmpty()) {
            xmlOutput.openTag("SuppressionFilter");
            this.suppressionFilter.writeBodyAsXML(xmlOutput);
            xmlOutput.closeTag("SuppressionFilter");
        }
        xmlOutput.closeTag("Project");
    }

    List<String> makeRelative(List<String> files, @CheckForNull Object destination) {
        File where;
        if (destination == null) {
            return files;
        }
        if (this.currentWorkingDirectoryList.isEmpty()) {
            return files;
        }
        if (destination instanceof File && (where = (File)destination).getParentFile().equals(this.currentWorkingDirectoryList.get(0))) {
            ArrayList<String> result = new ArrayList<String>(files.size());
            String root = where.getParent();
            for (String s : files) {
                if (s.startsWith(root)) {
                    result.add(s.substring(root.length()));
                    continue;
                }
                result.add(s);
            }
            return result;
        }
        return files;
    }

    private void parseOption(String option) throws IOException {
        int equalPos = option.indexOf("=");
        if (equalPos < 0) {
            throw new IOException("Bad format: invalid option format");
        }
        String name = option.substring(0, equalPos);
        String value = option.substring(equalPos + 1);
        this.optionsMap.put(name, Boolean.valueOf(value));
    }

    private String convertToRelative(String srcFile, String base) {
        String subPath;
        String root;
        String slash = SystemProperties.getProperty("file.separator");
        if (FILE_IGNORE_CASE) {
            srcFile = srcFile.toLowerCase();
            base = base.toLowerCase();
        }
        if (base.equals(srcFile)) {
            return ".";
        }
        if (!base.endsWith(slash)) {
            base = base + slash;
        }
        if (base.length() <= srcFile.length() && (root = srcFile.substring(0, base.length())).equals(base)) {
            return "." + SystemProperties.getProperty("file.separator") + srcFile.substring(base.length());
        }
        int slashPos = srcFile.indexOf(slash);
        if (slashPos >= 0 && ((subPath = srcFile.substring(0, slashPos)).length() == 0 || base.startsWith(subPath))) {
            int branchPoint = slashPos + 1;
            slashPos = srcFile.indexOf(slash, branchPoint);
            while (slashPos >= 0 && base.startsWith(subPath = srcFile.substring(0, slashPos))) {
                branchPoint = slashPos + 1;
                slashPos = srcFile.indexOf(slash, branchPoint);
            }
            int slashCount = 0;
            slashPos = base.indexOf(slash, branchPoint);
            while (slashPos >= 0) {
                ++slashCount;
                slashPos = base.indexOf(slash, slashPos + 1);
            }
            StringBuilder path = new StringBuilder();
            String upDir = ".." + slash;
            for (int i = 0; i < slashCount; ++i) {
                path.append(upDir);
            }
            path.append(srcFile.substring(branchPoint));
            return path.toString();
        }
        return srcFile;
    }

    private String convertToAbsolute(String fileName) throws IOException {
        File projectFile;
        File file = new File(fileName);
        if (!file.isAbsolute() && (projectFile = new File(this.projectFileName)).isAbsolute()) {
            String base = new File(this.projectFileName).getParent();
            fileName = new File(base, fileName).getCanonicalPath();
        }
        return fileName;
    }

    private String makeAbsoluteCWD(String fileName) {
        List<String> candidates = this.makeAbsoluteCwdCandidates(fileName);
        return candidates.get(0);
    }

    private List<String> makeAbsoluteCwdCandidates(String fileName) {
        boolean hasProtocol;
        ArrayList<String> candidates = new ArrayList<String>();
        boolean bl = hasProtocol = URLClassPath.getURLProtocol(fileName) != null;
        if (hasProtocol) {
            candidates.add(fileName);
            return candidates;
        }
        if (new File(fileName).isAbsolute()) {
            candidates.add(fileName);
            return candidates;
        }
        for (File currentWorkingDirectory : this.currentWorkingDirectoryList) {
            File relativeToCurrent = new File(currentWorkingDirectory, fileName);
            if (!relativeToCurrent.exists()) continue;
            candidates.add(relativeToCurrent.toString());
        }
        if (candidates.isEmpty()) {
            candidates.add(fileName);
        }
        return candidates;
    }

    private <T> boolean addToListInternal(Collection<T> list, T value) {
        if (!list.contains(value)) {
            list.add(value);
            this.isModified = true;
            return true;
        }
        return false;
    }

    private void makeListAbsoluteProject(List<String> list) throws IOException {
        LinkedList<String> replace = new LinkedList<String>();
        for (String fileName : list) {
            fileName = this.convertToAbsolute(fileName);
            replace.add(fileName);
        }
        list.clear();
        list.addAll(replace);
    }

    public void setTimestamp(long timestamp) {
        this.timestampForAnalyzedClasses = timestamp;
    }

    public void addTimestamp(long timestamp) {
        if (this.timestampForAnalyzedClasses < timestamp && FindBugs.validTimestamp(timestamp)) {
            this.timestampForAnalyzedClasses = timestamp;
        }
    }

    public long getTimestamp() {
        return this.timestampForAnalyzedClasses;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setSuppressionFilter(Filter suppressionFilter) {
        this.suppressionFilter = suppressionFilter;
    }

    public Filter getSuppressionFilter() {
        if (this.suppressionFilter == null) {
            this.suppressionFilter = new Filter();
        }
        return this.suppressionFilter;
    }

    public void setGuiCallback(IGuiCallback guiCallback) {
        this.guiCallback = guiCallback;
    }

    public IGuiCallback getGuiCallback() {
        return this.guiCallback;
    }

    public Iterable<String> getResolvedSourcePaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.srcDirList) {
            boolean hasProtocol;
            boolean bl = hasProtocol = URLClassPath.getURLProtocol(s) != null;
            if (hasProtocol) {
                result.add(s);
                continue;
            }
            File f = new File(s);
            if (f.isAbsolute() || this.currentWorkingDirectoryList.isEmpty()) {
                if (!f.canRead()) continue;
                result.add(s);
                continue;
            }
            for (File d : this.currentWorkingDirectoryList) {
                File a;
                if (!d.canRead() || !d.isDirectory() || !(a = new File(d, s)).canRead()) continue;
                result.add(a.getAbsolutePath());
            }
        }
        return result;
    }

    private static class WorkList {
        private LinkedList<WorkListItem> itemList = new LinkedList();
        private HashSet<String> addedSet = new HashSet();

        public URL createURL(String fileName) throws MalformedURLException {
            String protocol = URLClassPath.getURLProtocol(fileName);
            if (protocol == null) {
                fileName = "file:" + fileName;
            }
            return new URL(fileName);
        }

        public URL createRelativeURL(URL base, String fileName) throws MalformedURLException {
            return new URL(base, fileName);
        }

        public boolean add(WorkListItem item) {
            if (DEBUG) {
                System.out.println("Adding " + item.getURL().toString());
            }
            if (!this.addedSet.add(item.getURL().toString())) {
                if (DEBUG) {
                    System.out.println("\t==> Already processed");
                }
                return false;
            }
            this.itemList.add(item);
            return true;
        }

        public boolean isEmpty() {
            return this.itemList.isEmpty();
        }

        public WorkListItem getNextItem() {
            return this.itemList.removeFirst();
        }
    }

    private static class WorkListItem {
        private URL url;

        public WorkListItem(URL url) {
            this.url = url;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

