/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.WarningSuppressor;

public class ClassWarningSuppressor
extends WarningSuppressor {
    ClassAnnotation clazz;

    public ClassWarningSuppressor(String bugPattern, ClassAnnotation clazz) {
        super(bugPattern);
        this.clazz = clazz;
        if (DEBUG) {
            System.out.println("Suppressing " + bugPattern + " in " + clazz);
        }
    }

    public ClassAnnotation getClassAnnotation() {
        return this.clazz;
    }

    public boolean match(BugInstance bugInstance) {
        if (!super.match(bugInstance)) {
            return false;
        }
        ClassAnnotation primaryClassAnnotation = bugInstance.getPrimaryClass();
        if (DEBUG) {
            System.out.println("Compare " + primaryClassAnnotation + " with " + this.clazz);
        }
        return this.clazz.contains(primaryClassAnnotation);
    }
}

