/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.GroupType;
import de.tobject.findbugs.view.properties.PropPageTitleProvider;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabDescriptor;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabSelectionListener;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BugPatternSection
extends AbstractPropertySection {
    private Browser browser;
    private StyledText htmlControl;
    private DefaultInformationControl.IInformationPresenterExtension presenter;
    private Composite rootComposite;
    private BugPattern pattern;
    private TextPresentation presentation;
    private ScrolledComposite scrolledComposite;
    private ControlAdapter listener;
    private String oldText;
    private final PropPageTitleProvider titleProvider = new PropPageTitleProvider();
    private BugInstance bug;
    private Point scrollSize;
    private boolean inResize;
    private ITabSelectionListener tabSelectionListener;
    private TabbedPropertySheetPage page;
    protected String browserId;
    private volatile boolean allowUrlChange;

    public void createControls(Composite parent, TabbedPropertySheetPage page1) {
        super.createControls(parent, page1);
        this.page = page1;
        this.createRootComposite(parent);
        this.initScrolledComposite(parent);
        this.createBrowser(this.rootComposite);
    }

    private void createRootComposite(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        layout.marginRight = -5;
        this.rootComposite.setLayout((Layout)layout);
        this.rootComposite.setSize(-1, -1);
        this.tabSelectionListener = new ITabSelectionListener(){

            public void tabSelected(TabDescriptor tabDescriptor) {
                if (!BugPatternSection.this.rootComposite.isDisposed() && BugPatternSection.this.rootComposite.isVisible() && !tabDescriptor.isSelected()) {
                    BugPatternSection.this.updateBrowserSize();
                }
            }

            public void tabSelected(ITabDescriptor tabDescriptor) {
                if (!BugPatternSection.this.rootComposite.isDisposed() && BugPatternSection.this.rootComposite.isVisible() && !tabDescriptor.isSelected()) {
                    BugPatternSection.this.updateBrowserSize();
                }
            }
        };
        this.page.addTabSelectionListener(this.tabSelectionListener);
    }

    private void createBrowser(Composite parent) {
        Color background = this.page.getWidgetFactory().getColors().getBackground();
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        try {
            this.browser = new Browser(parent, 262144);
            this.browser.setLayoutData((Object)data);
            this.browser.setBackground(background);
            this.browser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    event.required = true;
                }
            });
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                }

                public void changing(LocationEvent event) {
                    if (BugPatternSection.this.allowUrlChange || "about:blank".equals(event.location)) {
                        return;
                    }
                    event.doit = false;
                    BugPatternSection.this.openBrowserInEditor(event);
                }
            });
        }
        catch (SWTError e) {
            this.presentation = new TextPresentation();
            this.htmlControl = new StyledText(parent, 8);
            this.getWidgetFactory().adapt((Composite)this.htmlControl);
            this.htmlControl.setLayoutData((Object)data);
            this.htmlControl.setBackground(background);
            try {
                this.presenter = new HTMLTextPresenter(false);
            }
            catch (Exception e2) {
                FindbugsPlugin plugin = FindbugsPlugin.getDefault();
                plugin.logException(new RuntimeException(e.getMessage(), e), "Could not create org.eclipse.swt.widgets.Composite.Browser");
                plugin.logException(new RuntimeException(e2.getMessage(), e2), "Could not create org.eclipse.jface.internal.text.html.HTMLTextPresenter");
            }
        }
    }

    private void initScrolledComposite(Composite parent) {
        this.scrolledComposite = ((TabbedPropertyComposite)this.page.getControl()).getScrolledComposite();
        if (this.scrolledComposite != null) {
            this.listener = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (!BugPatternSection.this.rootComposite.isDisposed() && BugPatternSection.this.rootComposite.isVisible()) {
                        BugPatternSection.this.updateBrowserSize();
                    }
                }
            };
            this.scrolledComposite.addControlListener((ControlListener)this.listener);
        }
    }

    protected void updateDisplay() {
        String html = null;
        if (this.browser != null && !this.browser.isDisposed()) {
            html = this.getHtml();
            this.updateBrowserSize();
            if (!html.equals(this.oldText)) {
                this.allowUrlChange = true;
                this.browser.setText(html);
                this.allowUrlChange = false;
            }
        } else if (this.htmlControl != null && !this.htmlControl.isDisposed() && this.presenter != null) {
            Rectangle clientArea = this.updateBrowserSize();
            this.htmlControl.setSize(clientArea.width - 5, clientArea.height - 5);
            html = this.getHtml();
            try {
                html = this.presenter.updatePresentation((Drawable)this.rootComposite.getShell().getDisplay(), html, this.presentation, clientArea.width, clientArea.height);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            this.htmlControl.setText(html);
        }
        this.oldText = html;
    }

    private Rectangle updateBrowserSize() {
        Point newScrollSize = this.scrolledComposite.getSize();
        Rectangle clientArea = this.scrolledComposite.getClientArea();
        Point rootSize = this.rootComposite.getSize();
        if (!(this.inResize || clientArea.width <= 0 || clientArea.height <= 0 || newScrollSize.equals((Object)this.scrollSize) && clientArea.width == rootSize.x && clientArea.height == rootSize.y)) {
            this.scrollSize = newScrollSize;
            this.inResize = true;
            this.rootComposite.setSize(clientArea.width, clientArea.height);
            this.scrolledComposite.setMinSize(clientArea.width, clientArea.height);
            this.scrolledComposite.layout();
            this.inResize = false;
        }
        return clientArea;
    }

    private String getHtml() {
        if (this.pattern == null) {
            return "";
        }
        boolean hasBug = this.bug != null;
        StringBuilder text = new StringBuilder();
        if (!hasBug) {
            text.append("<b>Pattern:</b> ");
            text.append(this.pattern.getShortDescription());
            text.append("<br>");
        } else {
            text.append("<b>Pattern</b> ");
        }
        text.append(this.titleProvider.getDetails(this.pattern));
        text.append("<br><br>");
        text.append(this.pattern.getDetailText());
        String html = text.toString();
        if (hasBug) {
            html = "<b>Bug:</b> " + this.toSafeHtml(this.bug.getAbridgedMessage()) + "<br>\n" + html;
        }
        return html;
    }

    private String toSafeHtml(String s) {
        if (s.indexOf(">") >= 0) {
            s = s.replace(">", "&gt;");
        }
        if (s.indexOf("<") >= 0) {
            s = s.replace("<", "&lt;");
        }
        return s;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        boolean contentChanged = this.contentChanged(selection);
        if (contentChanged) {
            this.updateDisplay();
        }
    }

    private boolean contentChanged(ISelection selection) {
        IMarker marker;
        boolean existsBefore;
        boolean bl = existsBefore = this.pattern != null;
        if (!(selection instanceof IStructuredSelection)) {
            this.bug = null;
            this.pattern = null;
            return existsBefore;
        }
        IStructuredSelection selection2 = (IStructuredSelection)selection;
        Object object = selection2.getFirstElement();
        if (object instanceof BugGroup) {
            BugGroup group = (BugGroup)object;
            if (group.getType() == GroupType.Pattern) {
                this.bug = null;
                BugPattern data = (BugPattern)group.getData();
                BugPattern old = this.pattern;
                this.pattern = data;
                return old != data;
            }
        } else if (object instanceof IMarker && MarkerUtil.isFindBugsMarker(marker = (IMarker)object)) {
            BugInstance bugInstance = MarkerUtil.findBugInstanceForMarker(marker);
            BugInstance old = this.bug;
            this.bug = bugInstance;
            this.pattern = this.bug != null ? this.bug.getBugPattern() : null;
            return old != bugInstance;
        }
        return existsBefore;
    }

    public void dispose() {
        if (this.rootComposite != null && !this.rootComposite.isDisposed()) {
            this.page.removeTabSelectionListener(this.tabSelectionListener);
            this.scrolledComposite.removeControlListener((ControlListener)this.listener);
            this.rootComposite.dispose();
        }
        super.dispose();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private void openBrowserInEditor(LocationEvent event) {
        URL url;
        try {
            url = new URL(event.location);
        }
        catch (MalformedURLException e) {
            return;
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser newBrowser = support.createBrowser(this.browserId);
            this.browserId = newBrowser.getId();
            newBrowser.openURL(url);
            return;
        }
        catch (PartInitException e) {
            FindbugsPlugin.getDefault().logException(e, "Can't open external browser");
            return;
        }
    }
}

