/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;

class DeltaInfo {
    final IMarker marker;
    final int changeKind;

    public DeltaInfo(IMarker marker, int kind) {
        Assert.isNotNull((Object)marker, (String)"Null marker reported!");
        this.marker = marker;
        this.changeKind = kind;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DeltaInfo) {
            return this.marker.equals(((DeltaInfo)obj).marker);
        }
        return false;
    }

    public int hashCode() {
        return this.marker.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.changeKind) {
            case 1: {
                sb.append("ADDED");
                break;
            }
            case 4: {
                sb.append("CHANGED");
                break;
            }
            case 2: {
                sb.append("REMOVED");
                break;
            }
            default: {
                sb.append(" ? ").append(this.changeKind);
            }
        }
        sb.append(" marker id ").append(this.marker.getId()).append(this.marker.toString().replace("org.eclipse.core.internal.resources.Marker@", "/"));
        return sb.toString();
    }

    public boolean isAdded() {
        return this.changeKind == 1;
    }

    public boolean isRemoved() {
        return this.changeKind == 2;
    }
}

