/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.GroupType;
import de.tobject.findbugs.view.explorer.Grouping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class BugLabelProvider
implements ILabelProvider,
IDescriptionProvider,
ICommonLabelProvider,
IColorProvider {
    private final WorkbenchLabelProvider wbProvider = new WorkbenchLabelProvider();
    private BugContentProvider provider;

    public Image getImage(Object element) {
        IMarker marker;
        if (element instanceof BugGroup) {
            BugGroup group = (BugGroup)element;
            if (group.getType() == GroupType.Class || group.getType() == GroupType.Package || group.getType() == GroupType.Project || group.getType() == GroupType.Marker) {
                return this.wbProvider.getImage(group.getData());
            }
            FindBugsMarker.Priority prio = group.getPriority();
            ImageRegistry imageRegistry = FindbugsPlugin.getDefault().getImageRegistry();
            return imageRegistry.get(prio.iconName());
        }
        if (element instanceof IMarker && !(marker = (IMarker)element).exists()) {
            return null;
        }
        return this.wbProvider.getImage(element);
    }

    boolean isStandalone() {
        return this.provider == null;
    }

    public String getText(Object element) {
        IMarker marker;
        if (element instanceof BugGroup) {
            BugGroup group = (BugGroup)element;
            if (this.isStandalone()) {
                return group.getShortDescription();
            }
            int filtered = this.getFilteredMarkersCount(group);
            String filterCount = filtered > 0 ? "/" + filtered + " filtered" : "";
            return group.getShortDescription() + " (" + (group.getMarkersCount() - filtered) + filterCount + ")";
        }
        if (element instanceof IMarker && !(marker = (IMarker)element).exists()) {
            return null;
        }
        if (element instanceof IStructuredSelection) {
            return this.getDescriptionAndBugCount(((IStructuredSelection)element).toArray());
        }
        if (element instanceof Object[]) {
            return this.getDescriptionAndBugCount((Object[])element);
        }
        return this.wbProvider.getText(element);
    }

    private int getFilteredMarkersCount(BugGroup group) {
        if (this.isStandalone() || !this.provider.isBugFilterActive()) {
            return 0;
        }
        return this.provider.getFilteredMarkersCount(group);
    }

    private String getDescriptionAndBugCount(Object[] objects) {
        if (objects.length == 0) {
            return "Nothing...";
        }
        if (objects.length == 1) {
            return this.getText(objects[0]);
        }
        int count = this.getBugCountsSum(objects);
        StringBuffer sb = new StringBuffer("Selection contains ");
        if (count == 1) {
            sb.append("exactly one single bug");
        } else if (count == 0) {
            sb.append("zero bugs (change filter settings to see more...)");
        } else {
            sb.append(count).append(" bugs");
        }
        if (this.isStandalone()) {
            sb.append(" (not filtered)");
        }
        return sb.toString();
    }

    private int getBugCountsSum(Object[] objects) {
        ArrayList<BugGroup> groups = new ArrayList<BugGroup>();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        for (Object object : objects) {
            if (object instanceof BugGroup) {
                groups.add((BugGroup)object);
                continue;
            }
            if (!(object instanceof IMarker)) continue;
            markers.add((IMarker)object);
        }
        if (groups.size() > 1 && !this.isStandalone()) {
            Collections.sort(groups, new Comparator<BugGroup>(){
                Grouping grouping;
                {
                    this.grouping = BugLabelProvider.this.getGrouping();
                }

                @Override
                public int compare(BugGroup o1, BugGroup o2) {
                    return this.grouping.compare(o1.getType(), o2.getType());
                }
            });
        }
        HashSet<BugGroup> finalGroups = new HashSet<BugGroup>();
        int count = 0;
        while (!groups.isEmpty()) {
            BugGroup g1 = (BugGroup)groups.remove(groups.size() - 1);
            boolean keepIt = true;
            for (BugGroup g2 : groups) {
                Object parent = g1.getParent();
                while (g2 != parent && parent instanceof BugGroup) {
                    parent = ((BugGroup)parent).getParent();
                }
                if (g2 != parent) continue;
                keepIt = false;
                break;
            }
            if (!keepIt) continue;
            finalGroups.add(g1);
            count += g1.getMarkersCount() - this.getFilteredMarkersCount(g1);
        }
        while (!markers.isEmpty()) {
            IMarker marker = (IMarker)markers.remove(markers.size() - 1);
            boolean keepIt = true;
            for (BugGroup group : finalGroups) {
                if (!group.contains(marker)) continue;
                keepIt = false;
                break;
            }
            if (!keepIt) continue;
            ++count;
        }
        return count;
    }

    public void init(ICommonContentExtensionSite config) {
        this.provider = BugContentProvider.getProvider(config.getService());
    }

    Grouping getGrouping() {
        return this.provider == null ? null : this.provider.getGrouping();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getDescription(Object anElement) {
        return this.getText(anElement);
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        BugGroup group;
        if (element instanceof BugGroup && this.getFilteredMarkersCount(group = (BugGroup)element) == group.getMarkersCount()) {
            return Display.getDefault().getSystemColor(8);
        }
        return null;
    }
}

