/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.GroupType;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugGroup
implements IAdaptable,
IActionFilter {
    private String shortDescription;
    private final Set<Object> children;
    private Set<IMarker> allMarkers;
    private Object parent;
    private final FindBugsMarker.Priority priority;
    private final Object self;
    private final GroupType type;

    BugGroup(Object parent, Object self, GroupType type, FindBugsMarker.Priority priority) {
        this.parent = parent;
        Assert.isNotNull((Object)((Object)type), (String)"Group type cannot be null");
        this.type = type;
        this.self = self == null ? this : self;
        this.children = new HashSet<Object>();
        this.priority = priority == null ? FindBugsMarker.Priority.Unknown : priority;
        this.allMarkers = new HashSet<IMarker>();
        if (parent instanceof BugGroup) {
            BugGroup bugGroup = (BugGroup)parent;
            bugGroup.addChild(this);
        }
    }

    public Object[] getChildren() {
        if (this.children.size() == 0) {
            return this.allMarkers.toArray(new Object[this.allMarkers.size()]);
        }
        return this.children.toArray(new Object[this.children.size()]);
    }

    public Set<IMarker> getAllMarkers() {
        return this.allMarkers;
    }

    public boolean contains(Object elt) {
        if (elt instanceof IMarker) {
            return this.allMarkers.contains(elt);
        }
        return this.children.contains(elt);
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            switch (this.type) {
                case Marker: {
                    break;
                }
                case Workspace: {
                    return "Overall issues number: ";
                }
                case WorkingSet: {
                    return "Overall issues number: ";
                }
                default: {
                    this.shortDescription = this.type.getMapper().getShortDescription(this.self);
                }
            }
        }
        return this.shortDescription;
    }

    public Object getParent() {
        return this.parent;
    }

    public int size() {
        return this.children.size();
    }

    public int getMarkersCount() {
        return this.allMarkers.size();
    }

    void addChild(Object child) {
        this.children.add(child);
        if (BugContentProvider.DEBUG) {
            System.out.println("Adding child: " + child + " to " + this);
        }
    }

    boolean removeChild(BugGroup child) {
        boolean removed = this.children.remove(child);
        if (BugContentProvider.DEBUG) {
            System.out.println("Removing child: " + child + " from " + this);
        }
        if (this.children.size() == 0) {
            if (this.getMarkersCount() > 0) {
                this.removeMarkers(this.allMarkers);
            }
        } else {
            this.removeMarkers(child.getAllMarkers());
        }
        child.dispose();
        return removed;
    }

    void addMarker(IMarker marker) {
        boolean added = this.allMarkers.add(marker);
        if (BugContentProvider.DEBUG) {
            System.out.println("Adding marker: " + marker.getId() + " to " + this + ", new? " + added);
        }
    }

    void removeMarker(IMarker marker) {
        if (this.allMarkers.isEmpty()) {
            return;
        }
        if (BugContentProvider.DEBUG) {
            System.out.println("Removing marker: " + marker.getId() + " from " + this);
        }
        this.allMarkers.remove(marker);
        if (this.parent instanceof BugGroup) {
            ((BugGroup)this.parent).removeMarker(marker);
        }
    }

    private void removeMarkers(Set<IMarker> markers) {
        if (markers.isEmpty() || this.allMarkers.isEmpty()) {
            return;
        }
        if (BugContentProvider.DEBUG) {
            for (IMarker marker : markers) {
                System.out.println("Removing marker: " + marker.getId() + " from " + this);
            }
        }
        if (markers == this.allMarkers) {
            this.allMarkers.clear();
        } else {
            this.allMarkers.removeAll(markers);
        }
        if (this.parent instanceof BugGroup) {
            ((BugGroup)this.parent).removeMarkers(markers);
        }
    }

    void setMarkers(Set<IMarker> markers) {
        this.allMarkers = markers;
    }

    public String toString() {
        return this.shortDescription == null ? this.getShortDescription() : this.shortDescription;
    }

    public FindBugsMarker.Priority getPriority() {
        return this.priority;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.self.getClass())) {
            return this.self;
        }
        if (ITaskListResourceAdapter.class == adapter) {
            return null;
        }
        return null;
    }

    public GroupType getType() {
        return this.type;
    }

    public Object getData() {
        return this.self;
    }

    void dispose() {
        this.children.clear();
        this.allMarkers.clear();
        this.parent = null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if ("type".equals(name)) {
            return this.getType().name().equals(value);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BugGroup)) {
            return false;
        }
        BugGroup bugGroup = (BugGroup)obj;
        if (!this.equals(this.parent, bugGroup.parent)) {
            return false;
        }
        if (this.self == null) {
            return super.equals(obj);
        }
        return this.self.equals(bugGroup.self);
    }

    public int hashCode() {
        if (this.self == null) {
            return super.hashCode();
        }
        return this.self.hashCode();
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

