/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.ResourceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.pde.internal.core.ClasspathUtilCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDEClassPathGenerator {
    public static String[] computeClassPath(IJavaProject javaProject) {
        String[] classPath = new String[]{};
        try {
            classPath = PDEClassPathGenerator.createPluginClassPath(javaProject);
        }
        catch (NoClassDefFoundError ce) {
            classPath = PDEClassPathGenerator.createJavaClasspath(javaProject);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not compute aux. classpath for project " + javaProject);
            return classPath;
        }
        return classPath;
    }

    private static String[] createJavaClasspath(IJavaProject javaProject) {
        String[] classPath = new String[]{};
        try {
            classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not compute aux. classpath for project " + javaProject);
        }
        return classPath;
    }

    private static String[] createPluginClassPath(IJavaProject javaProject) throws CoreException {
        String[] javaClassPath = PDEClassPathGenerator.createJavaClasspath(javaProject);
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject.getProject());
        if (model == null || model.getPluginBase().getId() == null) {
            return javaClassPath;
        }
        ArrayList<String> pdeClassPath = new ArrayList<String>();
        pdeClassPath.addAll(Arrays.asList(javaClassPath));
        BundleDescription target = model.getBundleDescription();
        HashSet<BundleDescription> bundles = new HashSet<BundleDescription>();
        if (target != null) {
            PDEClassPathGenerator.addDependentBundles(target, bundles);
        }
        IPath defaultOutputLocation = ResourceUtils.relativeToAbsolute(javaProject.getOutputLocation());
        for (BundleDescription bd : bundles) {
            IPluginModelBase model2 = PluginRegistry.findModel((BundleDescription)bd);
            ArrayList classpathEntries = new ArrayList();
            ClasspathUtilCore.addLibraries((IPluginModelBase)model2, classpathEntries);
            for (IClasspathEntry cpe : classpathEntries) {
                String locationStr;
                IPath location = cpe.getEntryKind() == 3 ? ResourceUtils.getOutputLocation(cpe, defaultOutputLocation) : cpe.getPath();
                if (location == null || pdeClassPath.contains(locationStr = location.toOSString())) continue;
                if (location.toFile().exists()) {
                    pdeClassPath.add(locationStr);
                    continue;
                }
                if (!(location = ResourceUtils.relativeToAbsolute(location)).toFile().exists()) continue;
                pdeClassPath.add(location.toOSString());
            }
        }
        return pdeClassPath.toArray(new String[pdeClassPath.size()]);
    }

    private static void addDependentBundles(BundleDescription bd, Set<BundleDescription> bundles) {
        BundleDescription[] bundles2;
        for (BundleDescription bundleDescription : bundles2 = PDEState.getDependentBundlesWithFragments((BundleDescription)bd)) {
            if (bundles.contains(bundleDescription)) continue;
            bundles.add(bundleDescription);
            PDEClassPathGenerator.addDependentBundles(bundleDescription, bundles);
        }
    }
}

