/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CFrame;
import apple.awt.GraphicsClipper;
import apple.awt.MyCToolkit;
import apple.awt.PeerImpl;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.PaintEvent;
import java.nio.ByteBuffer;
import jep.AppletFrame;
import jep.AppletHandlerFactory;
import sun.awt.RepaintArea;
import sun.java2d.SunGraphics2D;

public class MyCAppletFrame
extends CFrame {
    protected static boolean showDebugInfo = false;
    protected AppletFrame ancestor = null;

    public static MyCAppletFrame createNew(Frame frame, AppletFrame appletFrame) {
        MyCAppletFrame myCAppletFrame = new MyCAppletFrame(frame);
        myCAppletFrame.setAncestor(appletFrame);
        myCAppletFrame.initPeer();
        return myCAppletFrame;
    }

    public MyCAppletFrame(Component component) {
        super(component);
        if (showDebugInfo) {
            System.err.println("Called MyCAppletFrame(): Component (" + (component == null ? "null" : component.toString()) + ")");
        }
    }

    protected long initPeer(long l, long l2) {
        this.initContainer();
        Component component = MyCToolkit.getPeerTarget((PeerImpl)this);
        return this.createNativeEmbedded(this.ancestor.getCocoaParentView(), component.isEnabled(), component.isVisible(), this.fByteParameters);
    }

    protected long initPeer(long l) {
        this.initContainer();
        Component component = MyCToolkit.getPeerTarget((PeerImpl)this);
        if (AppletHandlerFactory.isJava160() && AppletHandlerFactory.getOSXVersion() < 4192) {
            return this.createNativeEmbedded(this.ancestor.getCocoaParentView(), component.isEnabled(), component.isVisible(), ((Window)component).isFocusableWindow(), this.fByteParameters);
        }
        return this.createNativeEmbedded(this.ancestor.getCocoaParentView(), component.isEnabled(), component.isVisible(), this.fByteParameters);
    }

    private native long createNativeEmbedded(long var1, boolean var3, boolean var4, ByteBuffer var5);

    private native long createNativeEmbedded(long var1, boolean var3, boolean var4, boolean var5, ByteBuffer var6);

    private native long _getViewPtr(long var1);

    public void setVisible(boolean bl) {
        this._setVisible(this.fModelPtr, bl);
    }

    public void updateMinimumSize() {
    }

    public void setAncestor(AppletFrame appletFrame) {
        this.ancestor = appletFrame;
    }

    protected long getCocoaParentView() {
        return this.ancestor.getCocoaParentView();
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent == null) {
            return;
        }
        if (!(aWTEvent instanceof PaintEvent)) {
            super.handleEvent(aWTEvent);
            return;
        }
        if (this.ancestor == null) {
            super.handleEvent(aWTEvent);
            return;
        }
        if (!AppletHandlerFactory.isAppletViewDisplayable(this.ancestor.getCocoaParentView())) {
            if (showDebugInfo) {
                System.err.println("MyCAppletFrame handleEvent(): Skipping paint event because applet invisible");
            }
            return;
        }
        if (this.ancestor.updatesOff) {
            if (showDebugInfo) {
                System.err.println("MyCAppletFrame handleEvent(): Skipping paint event because updates off");
            }
            return;
        }
        Rectangle rectangle = this.ancestor.translateCurrentClip(MyCToolkit.getPeerTarget((PeerImpl)this));
        Rectangle rectangle2 = ((PaintEvent)aWTEvent).getUpdateRect();
        if (rectangle2 == null) {
            super.handleEvent(aWTEvent);
            return;
        }
        rectangle = rectangle.intersection(rectangle2);
        if (showDebugInfo) {
            System.err.println("MyCAppletFrame handleEvent(): updateRect clipped from " + rectangle2.toString() + " to " + rectangle.toString());
        }
        if (!rectangle.isEmpty()) {
            RepaintArea repaintArea = new RepaintArea();
            repaintArea.add(rectangle, aWTEvent.getID());
            this.paintArea = repaintArea;
            ((PaintEvent)aWTEvent).setUpdateRect(rectangle);
            super.handleEvent(aWTEvent);
        }
    }

    public Graphics getGraphics() {
        SunGraphics2D sunGraphics2D = (SunGraphics2D)super.getGraphics();
        GraphicsClipper graphicsClipper = null;
        try {
            Object[] objectArray = new Object[]{sunGraphics2D, this.ancestor, this};
            graphicsClipper = (GraphicsClipper)AppletHandlerFactory.graphicsClipperCreateNew.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            System.err.println("MyCAppletFrame getGraphics(): exception: " + throwable.getMessage());
            throwable.printStackTrace();
            return sunGraphics2D;
        }
        graphicsClipper.validateDevClip();
        return sunGraphics2D;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }
}

