/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.jboss.ide.eclipse.freemarker.editor.AnnotationHover;
import org.jboss.ide.eclipse.freemarker.editor.ColorManager;
import org.jboss.ide.eclipse.freemarker.editor.CompletionProcessor;
import org.jboss.ide.eclipse.freemarker.editor.ContentScanner;
import org.jboss.ide.eclipse.freemarker.editor.DirectiveScanner;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.editor.MacroHyperlinkDetector;
import org.jboss.ide.eclipse.freemarker.editor.NonRuleBasedDamagerRepairer;
import org.jboss.ide.eclipse.freemarker.editor.PartitionScanner;
import org.jboss.ide.eclipse.freemarker.editor.XMLTagScanner;

public class Configuration
extends TextSourceViewerConfiguration {
    private ColorManager colorManager;
    private XMLTagScanner xmlTagScanner;
    private DirectiveScanner directiveScanner;
    private Editor editor;

    public Configuration(IPreferenceStore preferenceStore, ColorManager colorManager, Editor editor) {
        super(preferenceStore);
        this.editor = editor;
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return PartitionScanner.PARTITIONS;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        Token defaultToken = null;
        DefaultDamagerRepairer dr = null;
        NonRuleBasedDamagerRepairer ndr = null;
        defaultToken = new Token((Object)new TextAttribute(this.colorManager.getColor("color.directive")));
        ContentScanner contentScanner = new ContentScanner((IToken)defaultToken, this.colorManager);
        int i = 0;
        while (i < PartitionScanner.DIRECTIVES.length) {
            dr = new DefaultDamagerRepairer((ITokenScanner)contentScanner);
            reconciler.setDamager((IPresentationDamager)dr, PartitionScanner.DIRECTIVES[i]);
            reconciler.setRepairer((IPresentationRepairer)dr, PartitionScanner.DIRECTIVES[i]);
            ++i;
        }
        dr = new DefaultDamagerRepairer((ITokenScanner)contentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__ftl_directive");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ftl_directive");
        dr = new DefaultDamagerRepairer((ITokenScanner)contentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__ftl_directive_end");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ftl_directive_end");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor("color.xmlComment")));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor("color.string")));
        reconciler.setDamager((IPresentationDamager)ndr, "__string");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__string");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor("color.comment")));
        reconciler.setDamager((IPresentationDamager)ndr, "__ftl_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__ftl_comment");
        defaultToken = new Token((Object)new TextAttribute(this.colorManager.getColor("color.interpolation")));
        dr = new DefaultDamagerRepairer((ITokenScanner)new ContentScanner((IToken)defaultToken, this.colorManager));
        reconciler.setDamager((IPresentationDamager)dr, "__ftl_interpolation");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ftl_interpolation");
        defaultToken = new Token((Object)new TextAttribute(this.colorManager.getColor("color.xmlTag")));
        dr = new DefaultDamagerRepairer((ITokenScanner)new ContentScanner((IToken)defaultToken, this.colorManager));
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer aSourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        CompletionProcessor completionProcessor = new CompletionProcessor(this.editor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
        int i = 0;
        while (i < PartitionScanner.DIRECTIVES.length) {
            assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, PartitionScanner.DIRECTIVES[i]);
            ++i;
        }
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__ftl_directive");
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__ftl_directive_end");
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__ftl_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__ftl_interpolation");
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__xml_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__xml_tag");
        assistant.enableAutoInsert(true);
        assistant.enableAutoActivation(true);
        return assistant;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover();
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] detectors = super.getHyperlinkDetectors(sourceViewer);
        if (detectors == null) {
            detectors = new IHyperlinkDetector[]{};
        }
        IHyperlinkDetector[] detectorsNew = new IHyperlinkDetector[detectors.length + 1];
        System.arraycopy(detectors, 0, detectorsNew, 0, detectors.length);
        detectorsNew[detectorsNew.length - 1] = new MacroHyperlinkDetector((ITextViewer)sourceViewer, this.editor);
        return detectorsNew;
    }
}

