/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.actions.ViolationSelectionAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TableViewer;

public class RemoveViolationAction
extends ViolationSelectionAction {
    public RemoveViolationAction(TableViewer tableViewer) {
        super(tableViewer);
        this.setImageDescriptor(PMDPlugin.getImageDescriptor("icons/btn_remvio.gif"));
        this.setText(PMDPlugin.getDefault().getStringTable().getString("view.action.remove_violation"));
        this.setToolTipText(PMDPlugin.getDefault().getStringTable().getString("view.tooltip.remove_violation"));
    }

    public void run() {
        final IMarker[] iMarkerArray = this.getSelectedViolations();
        if (iMarkerArray != null) {
            try {
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                iWorkspace.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                        int n = 0;
                        while (n < iMarkerArray.length) {
                            iMarkerArray[n].delete();
                            ++n;
                        }
                    }
                }, null);
            }
            catch (CoreException coreException) {
                PMDPlugin.getDefault().logError(this.getString("message.error.core_exception"), coreException);
            }
        }
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

