/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ViolationOverviewContentProvider
implements ITreeContentProvider,
IStructuredContentProvider,
IResourceChangeListener {
    private static final Log LOG;
    protected static final Object[] NO_CHILDREN;
    protected boolean filterPackages;
    private final ViolationOverview violationView;
    private TreeViewer treeViewer;
    private RootRecord root;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        NO_CHILDREN = new Object[0];
    }

    public ViolationOverviewContentProvider(ViolationOverview violationOverview) {
        this.violationView = violationOverview;
        this.treeViewer = violationOverview.getViewer();
    }

    public void dispose() {
        if (this.root != null) {
            IWorkspaceRoot iWorkspaceRoot = (IWorkspaceRoot)this.root.getResource();
            iWorkspaceRoot.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = NO_CHILDREN;
        if (object instanceof IWorkspaceRoot || object instanceof RootRecord) {
            objectArray = this.getChildrenOfRoot();
        } else if (object instanceof PackageRecord) {
            objectArray = this.getChildrenOfPackage((PackageRecord)object);
        } else if (object instanceof FileRecord) {
            objectArray = this.getChildrenOfFile((FileRecord)object);
        } else if (object instanceof MarkerRecord) {
            objectArray = this.getChildrenOfMarker((MarkerRecord)object);
        }
        return objectArray;
    }

    private Object[] getChildrenOfFile(FileRecord fileRecord) {
        return fileRecord.getChildren();
    }

    private Object[] getChildrenOfMarker(MarkerRecord markerRecord) {
        markerRecord.updateChildren();
        return markerRecord.getChildren();
    }

    private Object[] getChildrenOfPackage(PackageRecord packageRecord) {
        Object[] objectArray = NO_CHILDREN;
        if (this.violationView.getShowType() == 3) {
            HashMap<String, AbstractPMDRecord> hashMap = new HashMap<String, AbstractPMDRecord>();
            List list = packageRecord.getChildrenAsList();
            int n = 0;
            while (n < list.size()) {
                AbstractPMDRecord abstractPMDRecord = (AbstractPMDRecord)list.get(n);
                List list2 = abstractPMDRecord.getChildrenAsList();
                int n2 = 0;
                while (n2 < list2.size()) {
                    AbstractPMDRecord abstractPMDRecord2 = (AbstractPMDRecord)list2.get(n2);
                    hashMap.put(abstractPMDRecord2.getName(), abstractPMDRecord2);
                    ++n2;
                }
                ++n;
            }
            objectArray = hashMap.values().toArray(new MarkerRecord[hashMap.size()]);
        } else {
            objectArray = packageRecord.getChildren();
        }
        return objectArray;
    }

    private Object[] getChildrenOfRoot() {
        Object[] objectArray = NO_CHILDREN;
        List list = this.root.getChildrenAsList();
        ProjectRecord[] projectRecordArray = new ProjectRecord[list.size()];
        list.toArray(projectRecordArray);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < projectRecordArray.length) {
            if (projectRecordArray[n].isProjectOpen()) {
                arrayList.addAll(projectRecordArray[n].getChildrenAsList());
            }
            ++n;
        }
        switch (this.violationView.getShowType()) {
            case 1: 
            case 3: {
                objectArray = arrayList.toArray();
                break;
            }
            case 2: {
                ArrayList arrayList2 = new ArrayList();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    AbstractPMDRecord abstractPMDRecord = (AbstractPMDRecord)arrayList.get(n2);
                    arrayList2.addAll(abstractPMDRecord.getChildrenAsList());
                    ++n2;
                }
                objectArray = arrayList2.toArray();
            }
        }
        return objectArray;
    }

    public Object getParent(Object object) {
        AbstractPMDRecord abstractPMDRecord = null;
        AbstractPMDRecord abstractPMDRecord2 = (AbstractPMDRecord)object;
        switch (this.violationView.getShowType()) {
            case 2: {
                if (object instanceof FileRecord) {
                    abstractPMDRecord = this.root;
                    break;
                }
                abstractPMDRecord = abstractPMDRecord2.getParent();
                break;
            }
            case 3: {
                if (object instanceof FileToMarkerRecord) {
                    abstractPMDRecord = abstractPMDRecord2.getParent();
                    break;
                }
                if (object instanceof PackageRecord) {
                    abstractPMDRecord = this.root;
                    break;
                }
                if (!(object instanceof MarkerRecord)) break;
                abstractPMDRecord = abstractPMDRecord2.getParent().getParent();
                break;
            }
            case 1: {
                abstractPMDRecord = object instanceof PackageRecord ? this.root : abstractPMDRecord2.getParent();
            }
        }
        return abstractPMDRecord;
    }

    public boolean hasChildren(Object object) {
        boolean bl = true;
        switch (this.violationView.getShowType()) {
            case 1: 
            case 2: {
                bl ^= object instanceof MarkerRecord;
                break;
            }
            case 3: {
                bl ^= object instanceof FileToMarkerRecord;
            }
        }
        if (bl) {
            bl = this.getChildren(object).length > 0;
        }
        return bl;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        LOG.debug((Object)"ViolationOverview inputChanged");
        this.treeViewer = (TreeViewer)viewer;
        IWorkspaceRoot iWorkspaceRoot = null;
        if (this.root != null) {
            LOG.debug((Object)"remove current listener");
            iWorkspaceRoot = (IWorkspaceRoot)this.root.getResource();
            iWorkspaceRoot.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (object2 instanceof IWorkspaceRoot) {
            LOG.debug((Object)"the new input is a workspace root");
            iWorkspaceRoot = (IWorkspaceRoot)object2;
            this.root = new RootRecord(iWorkspaceRoot);
            iWorkspaceRoot.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        } else if (object2 instanceof RootRecord) {
            LOG.debug((Object)"the new input is a root record");
            this.root = (RootRecord)object2;
            iWorkspaceRoot = (IWorkspaceRoot)this.root.getResource();
            iWorkspaceRoot.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        Object object;
        Object object2;
        LOG.debug((Object)"resource changed event");
        IMarkerDelta[] iMarkerDeltaArray = iResourceChangeEvent.findMarkerDeltas("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        while (n < iMarkerDeltaArray.length) {
            object2 = iMarkerDeltaArray[n].getResource();
            object = object2.getProject();
            if (!arrayList.contains(object2)) {
                arrayList.add(object2);
                LOG.debug((Object)("Resource " + object2.getName() + " has changed"));
            }
            if (!arrayList2.contains(object)) {
                arrayList2.add(object);
                LOG.debug((Object)("Project " + object.getName() + " has changed"));
            }
            ++n;
        }
        final ArrayList arrayList3 = new ArrayList();
        object2 = new ArrayList();
        object = new ArrayList();
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            List[] listArray;
            IProject iProject = (IProject)arrayList2.get(n2);
            LOG.debug((Object)("Processing changes for project " + iProject.getName()));
            ProjectRecord projectRecord = (ProjectRecord)this.root.findResource((IResource)iProject);
            if (!iProject.isOpen() || !iProject.isAccessible()) {
                LOG.debug((Object)"The project is not open or not accessible. Remove it");
                listArray = this.updateFiles(iProject, arrayList);
                object2.addAll(listArray[1]);
                this.root.removeResource((IResource)iProject);
            } else if (projectRecord == null) {
                LOG.debug((Object)"Cannot find a project record for it. Add it.");
                projectRecord = (ProjectRecord)this.root.addResource((IResource)iProject);
            }
            listArray = this.updateFiles(iProject, arrayList);
            arrayList3.addAll(listArray[0]);
            object2.addAll(listArray[1]);
            object.addAll(listArray[2]);
            ++n2;
        }
        this.treeViewer.getControl().getDisplay().syncExec(new Runnable((List)object2, (List)object){
            private final /* synthetic */ List val$removals;
            private final /* synthetic */ List val$changes;
            {
                this.val$removals = list2;
                this.val$changes = list3;
            }

            public void run() {
                ViolationOverviewContentProvider.this.updateViewer(arrayList3, this.val$removals, this.val$changes);
            }
        });
    }

    protected List[] updateFiles(IProject iProject, List list) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        List[] listArray = new List[]{arrayList, arrayList2, arrayList3};
        ProjectRecord projectRecord = (ProjectRecord)this.root.findResource((IResource)iProject);
        if (projectRecord != null && iProject.isAccessible()) {
            listArray = this.searchProjectForModifications(projectRecord, list);
        } else if (projectRecord != null) {
            List list2 = projectRecord.getChildrenAsList();
            arrayList2.addAll(list2);
            int n = 0;
            while (n < list2.size()) {
                PackageRecord packageRecord = (PackageRecord)list2.get(n);
                arrayList2.addAll(packageRecord.getChildrenAsList());
                ++n;
            }
            listArray = new List[]{arrayList, arrayList2, arrayList3};
        }
        return listArray;
    }

    private List[] searchProjectForModifications(ProjectRecord projectRecord, List list) {
        ArrayList<AbstractPMDRecord> arrayList = new ArrayList<AbstractPMDRecord>();
        ArrayList<AbstractPMDRecord> arrayList2 = new ArrayList<AbstractPMDRecord>();
        ArrayList<AbstractPMDRecord> arrayList3 = new ArrayList<AbstractPMDRecord>();
        IProject iProject = (IProject)projectRecord.getResource();
        LOG.debug((Object)("Analyses project " + iProject.getName()));
        int n = 0;
        while (n < list.size()) {
            IResource iResource = (IResource)list.get(n);
            LOG.debug((Object)("Analyses resource " + iResource.getName()));
            if (iProject.equals((Object)iResource.getProject())) {
                AbstractPMDRecord abstractPMDRecord;
                AbstractPMDRecord abstractPMDRecord2 = projectRecord.findResource(iResource);
                if (abstractPMDRecord2 != null && abstractPMDRecord2.getResourceType() == 1) {
                    abstractPMDRecord = (FileRecord)abstractPMDRecord2;
                    ((FileRecord)abstractPMDRecord).updateChildren();
                    if (((FileRecord)abstractPMDRecord).getResource().isAccessible() && ((FileRecord)abstractPMDRecord).hasMarkers()) {
                        LOG.debug((Object)"The file has changed");
                        arrayList3.add(abstractPMDRecord);
                    } else {
                        LOG.debug((Object)"The file has been removed");
                        projectRecord.removeResource(((FileRecord)abstractPMDRecord).getResource());
                        arrayList2.add(abstractPMDRecord);
                        PackageRecord packageRecord = (PackageRecord)((FileRecord)abstractPMDRecord).getParent();
                        if (!packageRecord.hasMarkers()) {
                            projectRecord.removeResource(((FileRecord)abstractPMDRecord).getParent().getResource());
                            arrayList2.add(packageRecord);
                        }
                    }
                } else if (abstractPMDRecord2 == null) {
                    LOG.debug((Object)"This is a new file.");
                    abstractPMDRecord = projectRecord.addResource(iResource);
                    arrayList.add(abstractPMDRecord);
                } else {
                    LOG.debug((Object)("The found resource is not a file ! type found : " + abstractPMDRecord2.getResourceType()));
                }
            } else {
                LOG.debug((Object)("The project resource is not the same ! (" + iResource.getProject().getName() + ")"));
            }
            ++n;
        }
        return new List[]{arrayList, arrayList2, arrayList3};
    }

    protected void updateViewer(List list, List list2, List list3) {
        if (list2.size() > 0) {
            this.treeViewer.cancelEditing();
            this.treeViewer.remove(list2.toArray());
        }
        if (list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                AbstractPMDRecord abstractPMDRecord = (AbstractPMDRecord)list.get(n);
                if (abstractPMDRecord instanceof FileRecord) {
                    this.treeViewer.add((Object)abstractPMDRecord.getParent(), (Object)abstractPMDRecord);
                } else {
                    this.treeViewer.add((Object)this.root, (Object)abstractPMDRecord);
                }
                ++n;
            }
        }
        if (list3.size() > 0) {
            this.treeViewer.update(list3.toArray(), null);
        }
        this.violationView.refresh();
    }
}

