/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlinePage;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ViolationOutlineContentProvider
implements IStructuredContentProvider,
IResourceChangeListener {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    private ViolationOutlinePage outlinePage;
    private TableViewer tableViewer;
    private FileRecord resource;

    public ViolationOutlineContentProvider(ViolationOutlinePage violationOutlinePage) {
        this.outlinePage = violationOutlinePage;
        this.tableViewer = violationOutlinePage.getTableViewer();
    }

    public Object[] getElements(Object object) {
        if (object instanceof FileRecord) {
            return ((FileRecord)object).findMarkers();
        }
        return NO_ELEMENTS;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (this.resource != null) {
            this.resource.getResource().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.resource = (FileRecord)object2;
        if (this.resource != null) {
            this.resource.getResource().getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.tableViewer = (TableViewer)viewer;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IMarkerDelta[] iMarkerDeltaArray = iResourceChangeEvent.findMarkerDeltas("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true);
        if (!this.resource.getResource().exists() || this.resource == null || iMarkerDeltaArray == null) {
            return;
        }
        final ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        final ArrayList<IMarker> arrayList2 = new ArrayList<IMarker>();
        final ArrayList<IMarker> arrayList3 = new ArrayList<IMarker>();
        int n = 0;
        while (n < iMarkerDeltaArray.length) {
            if (iMarkerDeltaArray[n].getResource().equals((Object)this.resource.getResource())) {
                IMarker iMarker = iMarkerDeltaArray[n].getMarker();
                switch (iMarkerDeltaArray[n].getKind()) {
                    case 1: {
                        arrayList.add(iMarker);
                        break;
                    }
                    case 2: {
                        arrayList2.add(iMarker);
                        break;
                    }
                    case 4: {
                        arrayList3.add(iMarker);
                    }
                }
            }
            ++n;
        }
        this.tableViewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                ViolationOutlineContentProvider.this.updateViewer(arrayList, arrayList2, arrayList3);
            }
        });
    }

    protected void updateViewer(List list, List list2, List list3) {
        if (list2.size() > 0) {
            this.tableViewer.cancelEditing();
            this.tableViewer.remove(list2.toArray());
        }
        if (list.size() > 0) {
            this.tableViewer.add(list.toArray());
        }
        if (list3.size() > 0) {
            this.tableViewer.update(list3.toArray(), null);
        }
        this.outlinePage.refresh();
    }
}

