/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.CPDViewDoubleClickEventListener;
import net.sourceforge.pmd.eclipse.ui.views.CPDViewLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.CPDViewTooltipListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class CPDView
extends ViewPart
implements IPropertyListener {
    private TreeViewer treeViewer;
    private TreeNodeContentProvider contentProvider;
    private CPDViewLabelProvider labelProvider;
    private CPDViewDoubleClickEventListener doubleClickListener;
    private CPDViewTooltipListener tooltipListener;
    private static final int MAX_MATCHES = 100;

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.contentProvider = new TreeNodeContentProvider();
        this.labelProvider = new CPDViewLabelProvider();
        this.doubleClickListener = new CPDViewDoubleClickEventListener(this);
        this.tooltipListener = new CPDViewTooltipListener(this);
    }

    public void createPartControl(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 66306);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickListener);
        this.tooltipListener.initialize();
        this.treeViewer.getTree().addListener(12, (Listener)this.tooltipListener);
        this.treeViewer.getTree().addListener(1, (Listener)this.tooltipListener);
        this.treeViewer.getTree().addListener(5, (Listener)this.tooltipListener);
        this.treeViewer.getTree().addListener(32, (Listener)this.tooltipListener);
        this.createColumns(this.treeViewer.getTree());
    }

    private void createColumns(Tree tree) {
        TreeColumn treeColumn = new TreeColumn(tree, 131072);
        treeColumn.setWidth(20);
        treeColumn.setResizable(false);
        TreeColumn treeColumn2 = new TreeColumn(tree, 0x1000000);
        treeColumn2.setWidth(20);
        treeColumn2.setResizable(false);
        TreeColumn treeColumn3 = new TreeColumn(tree, 16384);
        treeColumn3.setText(this.getString("view.column.message"));
        treeColumn3.setWidth(300);
        TreeColumn treeColumn4 = new TreeColumn(tree, 16384);
        treeColumn4.setText(this.getString("view.column.class"));
        treeColumn4.setWidth(300);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setData(Iterator iterator) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (iterator != null) {
            int n = 0;
            while (iterator.hasNext() && n < 100) {
                Match match = (Match)iterator.next();
                TreeNode treeNode = new TreeNode((Object)match);
                arrayList.add(treeNode);
                TreeNode[] treeNodeArray = new TreeNode[match.getMarkCount()];
                Iterator iterator2 = match.getMarkSet().iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    TokenEntry tokenEntry = (TokenEntry)iterator2.next();
                    treeNodeArray[n2] = new TreeNode((Object)tokenEntry);
                    treeNodeArray[n2].setParent(treeNode);
                    ++n2;
                }
                treeNode.setChildren(treeNodeArray);
                ++n;
            }
        }
        this.treeViewer.setInput((Object)arrayList.toArray(new TreeNode[arrayList.size()]));
    }

    public void propertyChanged(Object object, int n) {
        if (n == 1111 && object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            boolean bl = iterator.hasNext();
            this.setData(iterator);
            if (!bl) {
                MessageBox messageBox = new MessageBox(this.treeViewer.getControl().getShell());
                messageBox.setText(this.getString("dialog.cpd.no_results.header"));
                messageBox.setMessage(this.getString("dialog.cpd.no_results.body"));
                messageBox.open();
            }
        }
    }
}

