/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.quickfix;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.quickfix.Fix;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;

public class PMDResolution
implements IMarkerResolution,
IRunnableWithProgress {
    private static final Logger log;
    private Fix fix;
    private IFile file;
    private int lineNumber;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.quickfix.PMDResolution");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public PMDResolution(Fix fix) {
        this.fix = fix;
    }

    public String getLabel() {
        return this.fix.getLabel();
    }

    public void run(IMarker iMarker) {
        log.debug((Object)"fixing...");
        IResource iResource = iMarker.getResource();
        this.lineNumber = iMarker.getAttribute("lineNumber", 0);
        if (iResource instanceof IFile) {
            this.file = (IFile)iResource;
            try {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                progressMonitorDialog.run(false, false, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException invocationTargetException) {
                PMDPlugin.getDefault().showError(PMDPlugin.getDefault().getStringTable().getString("message.error.invocationtarget_exception"), invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                PMDPlugin.getDefault().showError(PMDPlugin.getDefault().getStringTable().getString("message.error.interrupted_exception"), interruptedException);
            }
        }
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            String string;
            iProgressMonitor.beginTask("", 2);
            iProgressMonitor.subTask(this.file.getName());
            InputStream inputStream = this.file.getContents();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            while (bufferedReader.ready()) {
                string = bufferedReader.readLine();
                printWriter.println(string);
            }
            iProgressMonitor.worked(1);
            string = this.fix.fix(stringWriter.toString(), this.lineNumber);
            this.file.setContents((InputStream)new ByteArrayInputStream(string.getBytes()), false, true, iProgressMonitor);
            iProgressMonitor.worked(1);
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().showError(PMDPlugin.getDefault().getStringTable().getString("message.error.core_exception"), coreException);
        }
        catch (IOException iOException) {
            PMDPlugin.getDefault().showError(PMDPlugin.getDefault().getStringTable().getString("message.error.io_exception"), iOException);
        }
    }
}

