/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class PackageRecord
extends AbstractPMDRecord {
    private final IPackageFragment packageFragment;
    private final ProjectRecord parent;
    private AbstractPMDRecord[] children;

    public PackageRecord(IPackageFragment iPackageFragment, ProjectRecord projectRecord) {
        if (iPackageFragment == null) {
            throw new IllegalArgumentException("fragment cannot be null");
        }
        if (projectRecord == null) {
            throw new IllegalArgumentException("record cannot be null");
        }
        this.packageFragment = iPackageFragment;
        this.parent = projectRecord;
        this.children = this.createChildren();
    }

    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    public IResource getResource() {
        IResource iResource = null;
        try {
            iResource = this.packageFragment.getCorrespondingResource();
        }
        catch (JavaModelException javaModelException) {
            PMDPlugin.getDefault().logError("message.error.javamodel_exception" + this.toString(), javaModelException);
        }
        return iResource;
    }

    public IPackageFragment getFragment() {
        return this.packageFragment;
    }

    protected final AbstractPMDRecord[] createChildren() {
        ArrayList<FileRecord> arrayList = new ArrayList<FileRecord>();
        try {
            ICompilationUnit[] iCompilationUnitArray = this.packageFragment.getCompilationUnits();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                IResource iResource = iCompilationUnitArray[n].getCorrespondingResource();
                if (iResource != null) {
                    arrayList.add(new FileRecord(iResource, this));
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.core_exception" + this.toString(), coreException);
        }
        return arrayList.toArray(new AbstractPMDRecord[arrayList.size()]);
    }

    public AbstractPMDRecord addResource(IResource iResource) {
        ICompilationUnit iCompilationUnit = this.packageFragment.getCompilationUnit(iResource.getName());
        FileRecord fileRecord = null;
        if (iCompilationUnit != null) {
            fileRecord = new FileRecord(iResource, this);
            List list = this.getChildrenAsList();
            list.add(fileRecord);
            this.children = new AbstractPMDRecord[list.size()];
            list.toArray(this.children);
        }
        return fileRecord;
    }

    public AbstractPMDRecord removeResource(IResource iResource) {
        List list = this.getChildrenAsList();
        AbstractPMDRecord abstractPMDRecord = null;
        boolean bl = false;
        int n = 0;
        while (n < list.size() && !bl) {
            AbstractPMDRecord abstractPMDRecord2 = (AbstractPMDRecord)list.get(n);
            if (abstractPMDRecord2.getResource().equals((Object)iResource)) {
                list.remove(n);
                this.children = new AbstractPMDRecord[list.size()];
                list.toArray(this.children);
                bl = true;
                abstractPMDRecord = abstractPMDRecord2;
            }
            ++n;
        }
        return abstractPMDRecord;
    }

    public String getName() {
        String string = this.packageFragment.getElementName();
        if (this.packageFragment.isDefaultPackage()) {
            string = PMDPlugin.getDefault().getStringTable().getString("view.default_package");
        }
        return string;
    }

    public int getResourceType() {
        return 2;
    }

    public boolean equals(Object object) {
        return object instanceof PackageRecord ? this.packageFragment.equals(((PackageRecord)object).packageFragment) : false;
    }

    public int hashCode() {
        return this.packageFragment.hashCode();
    }

    public int getNumberOfViolationsToPriority(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.children.length) {
            n2 += this.children[n3].getNumberOfViolationsToPriority(n, false);
            ++n3;
        }
        return n2;
    }

    public int getLOC() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            n += this.children[n2].getLOC();
            ++n2;
        }
        return n;
    }

    public int getNumberOfMethods() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            n += this.children[n2].getNumberOfMethods();
            ++n2;
        }
        return n;
    }
}

