/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.CharStream;
import net.sourceforge.pmd.ast.JavaCharStream;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.writer.IAstWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PMDGenerateASTAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    private static final Logger log;
    private IWorkbenchPart targetPart;
    private IStructuredSelection structuredSelection;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.actions.PMDGenerateASTAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        ISelection iSelection;
        log.info((Object)"Generation AST action requested");
        if (this.targetPart instanceof IViewPart && (iSelection = this.targetPart.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)iSelection;
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                progressMonitorDialog.run(false, false, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException invocationTargetException) {
                PMDPlugin.getDefault().showError(this.getString("message.error.invocationtarget_exception"), invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                PMDPlugin.getDefault().showError(this.getString("message.error.interrupted_exception"), interruptedException);
            }
        }
        if (this.targetPart instanceof IEditorPart) {
            iSelection = ((IEditorPart)this.targetPart).getEditorInput();
            if (iSelection instanceof IFileEditorInput) {
                this.generateAST(((IFileEditorInput)iSelection).getFile());
            } else {
                log.debug((Object)("The kind of editor input is not supported. The editor input if of type: " + iSelection.getClass().getName()));
            }
        } else {
            log.debug((Object)("This action is not supported on this kind of part. This part type is: " + this.targetPart.getClass().getName()));
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private void generateAST(IFile iFile) {
        log.info((Object)("Genrating AST for file " + iFile.getName()));
        try {
            JavaParser javaParser = new JavaParser((CharStream)new JavaCharStream(iFile.getContents()));
            ASTCompilationUnit aSTCompilationUnit = javaParser.CompilationUnit();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IAstWriter iAstWriter = PMDPlugin.getDefault().getAstWriter();
            iAstWriter.write(byteArrayOutputStream, aSTCompilationUnit);
            byteArrayOutputStream.flush();
            String string = iFile.getName();
            int n = string.indexOf(46);
            String string2 = String.valueOf(string.substring(0, n)) + ".ast";
            IFile iFile2 = null;
            IContainer iContainer = iFile.getParent();
            if (iContainer instanceof IFolder) {
                iFile2 = ((IFolder)iContainer).getFile(string2);
            } else if (iContainer instanceof IProject) {
                iFile2 = ((IProject)iContainer).getFile(string2);
            }
            if (iFile2 != null) {
                if (iFile2.exists()) {
                    iFile2.delete(false, null);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                iFile2.create((InputStream)byteArrayInputStream, false, null);
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().showError(this.getString("message.error.core_exception"), coreException);
        }
        catch (ParseException parseException) {
            PMDPlugin.getDefault().showError(this.getString("message.error.pmd_exception"), parseException);
        }
        catch (WriterException writerException) {
            PMDPlugin.getDefault().showError(this.getString("message.error.pmd_exception"), writerException);
        }
        catch (IOException iOException) {
            PMDPlugin.getDefault().showError(this.getString("message.error.io_exception"), iOException);
        }
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        iProgressMonitor.beginTask("", this.structuredSelection.size());
        Iterator iterator = this.structuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IAdaptable) {
                IResource iResource;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                    iProgressMonitor.subTask(iResource.getName());
                    this.generateAST((IFile)iResource);
                    iProgressMonitor.worked(1);
                    continue;
                }
                log.warn((Object)"The selected object cannot adapt to a resource");
                log.debug((Object)("   -> selected object : " + e));
                continue;
            }
            log.warn((Object)"The selected object is not adaptable");
            log.debug((Object)("   -> selected object : " + e));
        }
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

